/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.webdav.lib.Lock;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.LockMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.UnlockMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import smart_gs.logical.Preference;
import webdav.PropFindInfo;
import webdav.ssl.EasySSLProtocolSocketFactory;

public class WebDavProcessor {
    protected String host;
    protected int port;
    protected Protocol protocol;
    protected String urlStr;
    protected URL url;
    protected boolean login = false;
    protected boolean ssl = false;
    protected static WebDavProcessor singleton;
    protected HttpClient client = null;

    public static WebDavProcessor getInstance(boolean reset) {
        if (reset) {
            singleton = null;
        }
        return WebDavProcessor.getInstance();
    }

    public static boolean isLogin() {
        return singleton != null;
    }

    public static WebDavProcessor getInstance() {
        if (singleton == null) {
            boolean ssl_ = false;
            Preference preference = Preference.getInstance();
            String urlStr = preference.getWebdavServerPathString();
            URL url_ = null;
            try {
                url_ = new URL(urlStr);
            }
            catch (MalformedURLException e1) {
                return null;
            }
            String host = url_.getHost();
            int port = url_.getPort();
            if (port == -1) {
                port = urlStr.startsWith("https") ? 443 : 80;
            }
            if (urlStr.startsWith("https")) {
                ssl_ = true;
            }
            Protocol protocol = Protocol.getProtocol(url_.getProtocol());
            String username = preference.getWebdavUserName();
            String password = preference.getWebdavPassword();
            if (!urlStr.endsWith("/")) {
                urlStr = urlStr + "/";
            }
            String proxyaddress = null;
            int proxyport = -1;
            if (preference.getProxyAddress() != null && !preference.getProxyAddress().equals("")) {
                proxyaddress = preference.getProxyAddress();
            }
            try {
                proxyport = Integer.parseInt(preference.getProxyPort());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (ssl_) {
                    Protocol.registerProtocol("https", new Protocol("https", new EasySSLProtocolSocketFactory(), port));
                }
                if (!(singleton = new WebDavProcessor(urlStr, url_, host, port, protocol, ssl_)).login(username, password, proxyaddress, proxyport)) {
                    singleton = null;
                }
            }
            catch (Exception e) {
                singleton = null;
            }
        }
        return singleton;
    }

    public WebDavProcessor(String urlStr, URL url, String host, int port, Protocol protocol, boolean ssl) {
        this.urlStr = urlStr;
        this.url = url;
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.ssl = ssl;
    }

    public boolean login(String username, String password) throws IOException {
        return this.login(username, password, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String username, String password, String proxyaddress, int proxyport) throws IOException {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
        System.setProperty("httpclient.useragent", "SMART-GS");
        if (this.urlStr == null) {
            return false;
        }
        if (!this.urlStr.endsWith("/")) {
            this.urlStr = this.urlStr + "/";
        }
        UsernamePasswordCredentials loginCredentials = null;
        AuthScope loginAuthScope = null;
        HttpClient client_ = new HttpClient();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        if (!username.equals("")) {
            loginCredentials = new UsernamePasswordCredentials(username, password);
            loginAuthScope = new AuthScope(this.host, this.port);
            client_.getState().setCredentials(loginAuthScope, loginCredentials);
            client_.getParams().setAuthenticationPreemptive(true);
        }
        String proxy_host = proxyaddress;
        int proxy_port = proxyport;
        if (proxyaddress == null) {
            proxy_host = "";
        }
        if (!proxy_host.trim().equals("")) {
            AuthScope authScope = new AuthScope(proxy_host, proxy_port);
            HttpHost proxy = new HttpHost(proxy_host, proxy_port);
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials("", "");
            client_.getState().setProxyCredentials(authScope, usernamePasswordCredentials);
            client_.getHostConfiguration().setProxy(proxy_host, proxy_port);
        }
        OptionsMethod method = new OptionsMethod(this.urlStr);
        method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(3, false));
        method.setDoAuthentication(true);
        try {
            int state = client_.executeMethod(method);
            if (state == 200) {
                this.login = true;
                this.client = client_;
            } else {
                this.login = false;
            }
        }
        catch (HttpException he) {
            this.login = false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.login = false;
        }
        finally {
            method.releaseConnection();
        }
        return this.login;
    }

    public PropFindInfo[] getPropFindInfo(String path, int depth) throws IOException {
        return this.getPropFindInfo(path, null, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropFindInfo[] getPropFindInfo(String path_, String name, int depth) throws IOException {
        String path = this.getPath(path_);
        if (name != null) {
            path = path + name;
        }
        String requestpath = URIUtil.encodePath(this.urlStr + path);
        ArrayList<PropFindInfo> list = new ArrayList<PropFindInfo>();
        HttpMethodBase propfindMethod = null;
        try {
            Vector<String> props = new Vector<String>();
            props.add("lockdiscovery");
            props.add("resourcetype");
            props.add("getlastmodified");
            props.add("getcontentlength");
            props.add("displayname");
            propfindMethod = new PropFindMethod(requestpath, depth, props.elements());
            propfindMethod.setDoAuthentication(true);
            int state = this.client.executeMethod(propfindMethod);
            if (state != 207) {
                PropFindInfo[] propFindInfoArray = null;
                return propFindInfoArray;
            }
            URL requestURL = new URL(requestpath);
            Enumeration responses = ((XMLResponseMethodBase)propfindMethod).getResponses();
            String selfpath = URIUtil.decode(requestURL.getPath());
            while (responses.hasMoreElements()) {
                String displayname;
                String rengpathDecode;
                String rengpath;
                String temp;
                String href;
                ResponseEntity response = (ResponseEntity)responses.nextElement();
                String href_src = href = response.getHref();
                if (href.toLowerCase().startsWith("http") && href.toLowerCase().indexOf("://") != -1 && (href = (temp = href.substring(href.indexOf("://") + "://".length(), href.length())).substring(temp.indexOf("/"), temp.length())).startsWith("//")) {
                    href = href.substring(1, href.length());
                }
                if (!(rengpath = href).endsWith("/")) {
                    rengpath = rengpath + "/";
                }
                if ((rengpathDecode = URIUtil.decode(rengpath)).toLowerCase().equals(selfpath.toLowerCase()) && depth != 0) continue;
                PropFindInfo propFindInfo = new PropFindInfo();
                String abstpath = rengpath.substring(this.url.getPath().length(), rengpath.length());
                propFindInfo.setPath(URIUtil.decode(abstpath));
                if (abstpath.equals("")) {
                    propFindInfo.setDisplayname("/");
                } else if (path.equals("")) {
                    displayname = URIUtil.decode(abstpath);
                    if (displayname.endsWith("/")) {
                        displayname = displayname.substring(0, displayname.length() - 1);
                    }
                    if (displayname.startsWith("/")) {
                        displayname = displayname.substring(1, displayname.length());
                    }
                    propFindInfo.setDisplayname(displayname);
                } else {
                    displayname = abstpath.substring(URIUtil.encodePath(path).length(), abstpath.length());
                    if ((displayname = URIUtil.decode(displayname)).endsWith("/")) {
                        displayname = displayname.substring(0, displayname.length() - 1);
                    }
                    if (displayname.startsWith("/")) {
                        displayname = displayname.substring(1, displayname.length());
                    }
                    propFindInfo.setDisplayname(displayname);
                }
                Enumeration responseProperties = ((PropFindMethod)propfindMethod).getResponseProperties(href_src);
                while (responseProperties.hasMoreElements()) {
                    Property property = (Property)responseProperties.nextElement();
                    if (property.getLocalName().equals("resourcetype")) {
                        if (property.getPropertyAsString().equals("COLLECTION")) {
                            propFindInfo.setDirectory(true);
                            continue;
                        }
                        propFindInfo.setPath(path);
                        continue;
                    }
                    if (property.getLocalName().equals("getcontentlength")) {
                        try {
                            long contentlength = Long.parseLong(property.getPropertyAsString());
                            propFindInfo.setContentlength(contentlength);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (property.getLocalName().equals("getlastmodified")) {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                            Date lastmodified = sdf.parse(property.getPropertyAsString());
                            propFindInfo.setLastmodified(lastmodified);
                        }
                        catch (ParseException e) {}
                        continue;
                    }
                    if (property.getLocalName().equals("lockdiscovery")) {
                        LockDiscoveryProperty lockDiscoveryProperty;
                        Lock[] locks;
                        if (!(property instanceof LockDiscoveryProperty) || (locks = (lockDiscoveryProperty = (LockDiscoveryProperty)property).getActiveLocks()) == null) continue;
                        propFindInfo.setLock(true);
                        for (int i = 0; i < locks.length; ++i) {
                            propFindInfo.addLocks(locks[i]);
                        }
                        continue;
                    }
                    if (!property.getLocalName().equals("displayname") || property.getPropertyAsString().equals("")) continue;
                    propFindInfo.setDisplayname(property.getPropertyAsString());
                }
                list.add(propFindInfo);
            }
        }
        finally {
            if (propfindMethod != null) {
                propfindMethod.releaseConnection();
            }
        }
        if (list.size() == 0) {
            return null;
        }
        PropFindInfo[] propFindInfos = new PropFindInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            propFindInfos[i] = (PropFindInfo)list.get(i);
        }
        return propFindInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String path_, String name, File file) throws IOException {
        String path = this.getPath(path_);
        String requestpath = URIUtil.encodePath(this.urlStr + path);
        HttpMethodBase getMethod = null;
        try {
            int len;
            getMethod = new GetMethod(requestpath + URIUtil.encodePath(name));
            getMethod.setDoAuthentication(true);
            int state = this.client.executeMethod(getMethod);
            if (state != 200) {
                boolean bl = false;
                return bl;
            }
            FileOutputStream fo = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            InputStream is = getMethod.getResponseBodyAsStream();
            while ((len = is.read(buf)) != -1) {
                fo.write(buf, 0, len);
            }
            fo.flush();
            fo.close();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String path_, String name, String outputpath) throws IOException {
        String path = this.getPath(path_);
        String requestpath = URIUtil.encodePath(this.urlStr + path);
        HttpMethodBase getMethod = null;
        try {
            int len;
            getMethod = new GetMethod(requestpath + URIUtil.encodePath(name));
            getMethod.setDoAuthentication(true);
            int state = this.client.executeMethod(getMethod);
            if (state != 200) {
                boolean bl = false;
                return bl;
            }
            if (!outputpath.endsWith("/")) {
                outputpath = outputpath + "/";
            }
            FileOutputStream fo = new FileOutputStream(outputpath + name);
            byte[] buf = new byte[1024];
            InputStream is = getMethod.getResponseBodyAsStream();
            while ((len = is.read(buf)) != -1) {
                fo.write(buf, 0, len);
            }
            fo.flush();
            fo.close();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String path_, String name, File file, String lockToken) throws IOException {
        String path = this.getPath(path_);
        String requestpath = URIUtil.encodePath(this.urlStr + path);
        HttpMethodBase putMethod = null;
        try {
            putMethod = new PutMethod(requestpath + URIUtil.encodePath(name));
            if (lockToken != null) {
                putMethod.setRequestHeader("If", "<" + requestpath + name + "> (<" + lockToken + ">)");
            }
            putMethod.setDoAuthentication(true);
            InputStreamRequestEntity requestEntity = null;
            if (!file.isFile() || !file.exists()) {
                putMethod.releaseConnection();
                boolean size = false;
                return size;
            }
            long size = file.length();
            FileInputStream fis = new FileInputStream(file);
            requestEntity = new InputStreamRequestEntity((InputStream)fis, size);
            ((EntityEnclosingMethod)putMethod).setRequestEntity(requestEntity);
            int state = this.client.executeMethod(putMethod);
            if (state < 200 || state >= 300) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (putMethod != null) {
                putMethod.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lock(String path_, String name, String owner) throws IOException {
        String path = this.getPath(path_);
        if (name != null) {
            path = path + name;
        }
        String requestpath = URIUtil.encodePath(this.urlStr + path);
        String lockToken = null;
        HttpMethodBase lockMethod = null;
        try {
            lockMethod = new LockMethod(requestpath, owner, 0, Integer.MAX_VALUE);
            lockMethod.setDoAuthentication(true);
            int state = this.client.executeMethod(lockMethod);
            if (state != 200) {
                String string = null;
                return string;
            }
            lockToken = ((LockMethod)lockMethod).getLockToken();
        }
        finally {
            if (lockMethod != null) {
                lockMethod.releaseConnection();
            }
        }
        return lockToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String path_, String name, String locktoken) throws IOException {
        if (locktoken == null) {
            return true;
        }
        String path = this.getPath(path_);
        if (name != null) {
            path = path + name;
        }
        String requestpath = URIUtil.encodePath(this.urlStr + path);
        UnlockMethod unlockMethod = null;
        try {
            unlockMethod = new UnlockMethod(requestpath, locktoken);
            unlockMethod.setDoAuthentication(true);
            int state = this.client.executeMethod(unlockMethod);
            if (state != 200) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (unlockMethod != null) {
                unlockMethod.releaseConnection();
            }
        }
        return true;
    }

    public String getPath(String path_) {
        String path = path_;
        if (path == null) {
            path = "";
        }
        if (!path.equals("")) {
            if (!path.equals("/")) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
            } else {
                path = "";
            }
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
        }
        return path;
    }
}

