/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import smart_gs.logical.Preference;
import webdav.PropFindInfo;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavProcessor;
import webdav.WebDavUploadLoadEvent;
import webdav.WebDavViewTableFactory;
import webdav.table.PropFindSort;

public class WebDavChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JDialog myJDialog = this;
    private WebDavDownLoadEvent webDavDownLoadEvent;
    private WebDavUploadLoadEvent webDavUploadLoadEvent;
    private int mode = 0;
    private String owner;
    protected WebDavProcessor webDavProcessor;
    protected WebDavViewTableFactory webDavViewTableFactory;
    private JButton jButton2 = null;
    private JTextField filenameField = null;
    private JLabel jLabel = null;
    private Stack<String> stack = null;
    private String startpath = null;
    private boolean error = false;
    private boolean cancel = false;
    private JButton jButton3 = null;

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(27, 13, 599, 255));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            PropFindInfo[] propFindInfoChild = null;
            try {
                PropFindInfo[] propFindInfo = this.startpath != null ? this.webDavProcessor.getPropFindInfo(this.startpath, 0) : this.webDavProcessor.getPropFindInfo("", 0);
                try {
                    propFindInfoChild = this.webDavProcessor.getPropFindInfo(propFindInfo[0].getPath(), 1);
                    propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
                    if (this.stack != null && this.stack.size() >= 1) {
                        PropFindInfo[] propFindInfoChildTemp = new PropFindInfo[propFindInfoChild.length + 1];
                        PropFindInfo propFindInfoUp = new PropFindInfo();
                        propFindInfoUp.setDisplayname("..");
                        propFindInfoUp.setDirectory(true);
                        propFindInfoChildTemp[0] = propFindInfoUp;
                        for (int i = 0; i < propFindInfoChild.length; ++i) {
                            propFindInfoChildTemp[i + 1] = propFindInfoChild[i];
                        }
                        propFindInfoChild = propFindInfoChildTemp;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.webDavViewTableFactory = new WebDavViewTableFactory(this.mode, propFindInfoChild, Color.WHITE);
            this.webDavViewTableFactory.setWebDavProcessor(this.webDavProcessor);
            this.webDavViewTableFactory.setWebDavDownLoadEvent(this.webDavDownLoadEvent);
            this.webDavViewTableFactory.seWebDavUploadLoadEvent(this.webDavUploadLoadEvent);
            this.webDavViewTableFactory.setOwner(this.owner);
            this.webDavViewTableFactory.setFilenameField(this.getFilenameField());
            if (this.stack != null) {
                this.webDavViewTableFactory.setStack(this.stack);
            }
            this.jTable = this.webDavViewTableFactory.getJTable();
        }
        return this.jTable;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setBounds(new Rectangle(390, 272, 110, 30));
            if (this.mode == 0) {
                this.jButton.setText("Open");
                this.jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebDavChooser.this.webDavViewTableFactory.downlaod();
                    }
                });
            } else {
                this.jButton.setText("Save");
                this.jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebDavChooser.this.webDavViewTableFactory.upload();
                    }
                });
            }
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setBounds(new Rectangle(506, 272, 110, 30));
            this.jButton1.setText("Cancel");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebDavChooser.this.cancel = true;
                    WebDavChooser.this.myJDialog.setVisible(false);
                }
            });
        }
        return this.jButton1;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setBounds(new Rectangle(506, 306, 110, 30));
            this.jButton2.setText("Unlock");
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebDavChooser.this.webDavViewTableFactory.unlock();
                }
            });
        }
        return this.jButton2;
    }

    public WebDavChooser(Frame frame, int mode, String owner, Stack<String> stack, String startpath) {
        super(frame, true);
        this.mode = mode;
        this.owner = owner;
        this.stack = stack;
        this.startpath = startpath;
        this.initialize();
    }

    private void initialize() {
        this.webDavProcessor = WebDavProcessor.getInstance();
        if (this.webDavProcessor == null) {
            JOptionPane.showMessageDialog(new JFrame(), "It failed in login to WebDAV.", "fatal", 0);
            this.setVisible(false);
            this.error = true;
            return;
        }
        this.webDavDownLoadEvent = new WebDavDownLoadEvent(this);
        this.setSize(659, 376);
        this.setContentPane(this.getJContentPane());
        if (this.mode == 0) {
            this.setTitle("Open from WebDAV");
        } else {
            this.setTitle("Save to WebDAV");
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJScrollPane(), null);
            this.jContentPane.add((Component)this.getJButton(), null);
            this.jContentPane.add((Component)this.getJButton1(), null);
            String unlockStr = Preference.getInstance().getWebdavunlock();
            if (unlockStr != null && unlockStr.equals("1")) {
                this.jContentPane.add((Component)this.getJButton2(), null);
            }
            this.jContentPane.add((Component)this.getJButton3(), null);
            if (this.getFilenameField() != null) {
                this.jContentPane.add((Component)this.getFilenameField(), null);
                this.jLabel = new JLabel();
                this.jLabel.setBounds(new Rectangle(51, 278, 61, 27));
                this.jLabel.setText("file name");
                this.jContentPane.add((Component)this.jLabel, null);
            }
        }
        return this.jContentPane;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel = true;
            this.setVisible(false);
        }
    }

    public WebDavDownLoadEvent getWebDavChooserEvent() {
        return this.webDavDownLoadEvent;
    }

    public WebDavUploadLoadEvent getWebDavUploadLoadEvent() {
        return this.webDavUploadLoadEvent;
    }

    public void setWebDavUploadLoadEvent(WebDavUploadLoadEvent webDavUploadLoadEvent) {
        this.webDavUploadLoadEvent = webDavUploadLoadEvent;
        if (this.webDavViewTableFactory != null) {
            if (this.webDavUploadLoadEvent != null && this.getFilenameField() != null && this.webDavUploadLoadEvent.getUploadname() != null) {
                this.getFilenameField().setText(this.webDavUploadLoadEvent.getUploadname());
            }
            this.webDavViewTableFactory.seWebDavUploadLoadEvent(webDavUploadLoadEvent);
        }
    }

    private JTextField getFilenameField() {
        if (this.filenameField == null && this.mode == 1) {
            this.filenameField = new JTextField();
            this.filenameField.setBounds(new Rectangle(116, 279, 267, 24));
        }
        return this.filenameField;
    }

    public void setLockToken(String lockToken) {
        if (this.webDavViewTableFactory != null) {
            this.webDavViewTableFactory.setLockToken(lockToken);
        }
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private JButton getJButton3() {
        if (this.jButton3 == null) {
            this.jButton3 = new JButton();
            this.jButton3.setBounds(new Rectangle(390, 306, 110, 30));
            this.jButton3.setText("Lock");
            this.jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebDavChooser.this.webDavViewTableFactory.lock();
                }
            });
        }
        return this.jButton3;
    }
}

