/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.node;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import sml_editor.node.SmlChildNode;

public class SmlText
extends SmlChildNode {
    private Text fText;

    public SmlText(Text text) {
        this.fText = text;
        this.fLength = this.calculateLength();
    }

    @Override
    public Node getNode() {
        return this.fText;
    }

    @Override
    public String getNodeName() {
        return this.fText.getNodeName();
    }

    @Override
    public void setNodeValue(String nodeValue) {
        int oldLength = this.fLength;
        this.fText.setData(nodeValue);
        this.fLength = this.calculateLength();
        if (this.fParent != null) {
            this.fParent.plusLength(this.fLength - oldLength);
        }
    }

    @Override
    protected int calculateLength() {
        return this.fText.getLength();
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeValue() {
        return this.fText.getNodeValue();
    }

    public SmlText splitText(int offset) {
        SmlText brother = new SmlText(this.fText.splitText(offset));
        this.fParent.insertBefore2(brother, this.getNextSibling());
        this.fLength = this.calculateLength();
        this.fParent.plusLength(-1 * brother.getLength());
        return brother;
    }

    public String substringData(int offset, int count) throws DOMException {
        return this.fText.substringData(offset, count);
    }

    public void appendData(String arg) throws DOMException {
        this.insertData(this.getNodeValue().length(), arg);
    }

    public void insertData(int offset, String arg) throws DOMException {
        this.fText.insertData(offset, arg);
        this.fLength += arg.length();
        this.fParent.plusLength(arg.length());
    }

    public void deleteData(int offset, int count) throws DOMException {
        int oldLength = this.calculateLength();
        this.fText.deleteData(offset, count);
        this.fLength = this.calculateLength();
        this.fParent.plusLength(this.fLength - oldLength);
    }
}

