/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.node;

import java.util.NoSuchElementException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sml_editor.node.SmlChildNode;
import sml_editor.node.SmlNode;

public class SmlElement
extends SmlChildNode {
    private Element fElement;
    private Vector<SmlNode> fChildren = new Vector();

    public SmlElement(Element elem) {
        this.fElement = elem;
    }

    @Override
    public Node getNode() {
        return this.fElement;
    }

    @Override
    public SmlNode appendChild(SmlNode newChild) {
        return this.insertBefore(newChild, null);
    }

    public SmlNode appendChild2(SmlNode newChild) {
        return this.insertBefore2(newChild, null);
    }

    @Override
    public SmlNode insertBefore(SmlNode newChild, SmlNode refChild) {
        SmlNode node = this.insertBefore2(newChild, refChild);
        if (refChild == null) {
            this.fElement.insertBefore(newChild.getNode(), null);
        } else {
            this.fElement.insertBefore(newChild.getNode(), refChild.getNode());
        }
        return node;
    }

    public SmlNode insertBefore2(SmlNode newChild, SmlNode refChild) {
        if (refChild == null) {
            this.fChildren.add(newChild);
        } else {
            int index = this.fChildren.indexOf(refChild);
            this.fChildren.add(index, newChild);
        }
        newChild.setParentNode(this);
        this.plusLength(newChild.getLength());
        return newChild;
    }

    @Override
    public SmlNode removeChild(SmlNode oldChild) {
        this.fChildren.remove(oldChild);
        this.fElement.removeChild(oldChild.getNode());
        this.plusLength(-1 * oldChild.getLength());
        return oldChild;
    }

    @Override
    public SmlNode replaceChild(SmlNode newChild, SmlNode oldChild) {
        this.insertBefore(newChild, oldChild);
        this.removeChild(oldChild);
        return oldChild;
    }

    @Override
    public SmlNode getFirstChild() {
        try {
            return this.fChildren.firstElement();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public SmlNode getLastChild() {
        try {
            return this.fChildren.lastElement();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean hasAttributes() {
        return this.fElement.hasAttributes();
    }

    protected int indexOf(SmlNode childNode) {
        return this.fChildren.indexOf(childNode);
    }

    protected SmlNode getChild(int index) {
        try {
            return this.fChildren.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    protected int calculateLength() {
        int sum = 0;
        for (int i = 0; i < this.fChildren.size(); ++i) {
            sum += this.fChildren.get(i).getLength();
        }
        return sum;
    }

    void plusLength(int increment) {
        int length = this.fLength + increment;
        if (this.fParent != null) {
            this.fLength = length;
            this.fParent.plusLength(increment);
        } else {
            this.fLength = length;
        }
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.fElement.getTagName();
    }
}

