/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.node;

import sml_editor.node.SmlElement;
import sml_editor.node.SmlNode;

public abstract class SmlChildNode
implements SmlNode {
    protected int fLength;
    protected SmlElement fParent;

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public SmlNode getParentNode() {
        return this.fParent;
    }

    @Override
    public void setParentNode(SmlElement parent) {
        if (this.fParent != null && this.fParent != parent) {
            this.fParent.removeChild(this);
        }
        this.fParent = parent;
    }

    @Override
    public SmlNode getNextSibling() {
        int index = this.fParent.indexOf(this);
        return this.fParent.getChild(index + 1);
    }

    @Override
    public SmlNode getPreviousSibling() {
        int index = this.fParent.indexOf(this);
        return this.fParent.getChild(index - 1);
    }

    @Override
    public SmlNode appendChild(SmlNode newChild) {
        return null;
    }

    @Override
    public SmlNode removeChild(SmlNode oldChild) {
        return null;
    }

    @Override
    public SmlNode replaceChild(SmlNode newChild, SmlNode oldChild) {
        return null;
    }

    @Override
    public SmlNode insertBefore(SmlNode newChild, SmlNode refChild) {
        return null;
    }

    @Override
    public SmlNode getFirstChild() {
        return null;
    }

    @Override
    public SmlNode getLastChild() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) {
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public boolean isNodeAncestor(SmlNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        SmlNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParentNode()) != null);
        return false;
    }

    @Override
    public SmlNode getSharedAncestor(SmlNode anotherNode) {
        SmlNode node2;
        SmlNode node1;
        int diff;
        if (anotherNode == this) {
            return this;
        }
        if (anotherNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = anotherNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = anotherNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = anotherNode;
        }
        while (diff > 0) {
            node1 = node1.getParentNode();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParentNode();
            node2 = node2.getParentNode();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    @Override
    public int getLevel() {
        int levels = 0;
        for (SmlNode ancestor = this.getParentNode(); ancestor != null; ancestor = ancestor.getParentNode()) {
            ++levels;
        }
        return levels;
    }

    @Override
    public boolean isRootElement() {
        return this.fParent == null;
    }

    @Override
    public String getPathFromRootElement() {
        SmlChildNode child = this;
        StringBuffer buffer = new StringBuffer();
        for (SmlElement parent = this.fParent; parent != null; parent = (SmlElement)parent.getParentNode()) {
            int num = parent.indexOf(child);
            buffer.insert(0, "/" + num);
            child = parent;
        }
        return buffer.toString();
    }

    protected abstract int calculateLength();
}

