/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.ResourceSelectionState;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.swingui.ButtonDialog;
import smart_gs.util.ResourceNotify;
import smart_gs.util.ResourcePanelFrame;

public class ResourceSelectionDialog
extends ButtonDialog
implements ResourceNotify {
    protected JTextField selectionField;
    private JTextField tempField;
    protected GSResource selectedResource;
    private JPanel mainPanel;

    public ResourceSelectionDialog(Frame parent, String title) {
        super(parent, title);
        this.toFront();
        this.selectionField = new JTextField(20);
        this.tempField = new JTextField(20);
        JButton reference = new JButton("Reference");
        reference.addActionListener(new ReferenceAction());
        this.mainPanel = new JPanel(new GridLayout(2, 1));
        JPanel panel = new JPanel();
        panel.add(this.selectionField);
        panel.add(reference);
        JPanel panel2 = new JPanel();
        JButton click = new JButton("select by click");
        click.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceSelectionDialog.this.addResource();
            }
        });
        panel2.add(click);
        this.mainPanel.add(panel);
        this.mainPanel.add(panel2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void addResource() {
        DefaultState.setDefaultState(ResourceSelectionState.getInstance());
        ((ResourceSelectionState)ResourceSelectionState.getInstance()).addNotifyElement(this);
        this.select();
    }

    protected void restore() {
        this.getContentPane().removeAll();
        DefaultState.restoreDefaultState();
        this.selectionField.setText(this.tempField.getText());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.validate();
    }

    public void select() {
        JPanel panel = new JPanel();
        panel.add(this.tempField);
        JButton restore = new JButton("OK");
        restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResourceSelectionDialog.this.restore();
            }
        });
        panel.add(restore);
        this.getContentPane().removeAll();
        this.getContentPane().add(panel);
        this.pack();
        this.validate();
    }

    public ResourceSelectionDialog(GSEditorFrame parent) {
        this(parent.getFrame(), "Select Region");
    }

    @Override
    public void notifyResourceSelection(GSResource resource) {
        this.selectedResource = resource;
        this.tempField.setText(resource.getURI());
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    @Override
    public void ok() {
        GS_RWRepository.getInstance().register(this.selectedResource);
    }

    private class ReferenceAction
    implements ActionListener {
        private ReferenceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            new ResourcePanelFrame();
        }
    }
}

