/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.swingui.ResultListPanel;

public class SearchResultViewer
extends JFrame {
    private JPanel queryPanel;
    private ResultListPanel resultListPanel;
    private JPanel buttonPanel;
    private JButton backButton;
    private JButton nextButton;
    private final int SIZE_TO_DISPLAY = 10;

    public SearchResultViewer(String queryText, ArrayList<SearchResult> results) {
        super("Search Result");
        JPanel mainPanel = new JPanel();
        this.add((Component)mainPanel, "Center");
        mainPanel.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.setSize(400, 800);
        this.queryPanel = new JPanel();
        this.queryPanel.setLayout(new BorderLayout());
        JTextField queryField = new JTextField();
        queryField.setHorizontalAlignment(2);
        queryField.setFont(new Font("default", 0, 20));
        queryField.setText(queryText);
        queryField.setBackground(Color.white);
        queryField.setOpaque(true);
        queryField.setEditable(false);
        queryField.setPreferredSize(new Dimension(380, 40));
        this.queryPanel.add((Component)queryField, "West");
        mainPanel.add((Component)this.queryPanel, "North");
        this.queryPanel.setBorder(new TitledBorder("Query Text:"));
        this.resultListPanel = new ResultListPanel(queryText, 10, results.size(), results);
        mainPanel.add((Component)this.resultListPanel, "Center");
        this.buttonPanel = new JPanel();
        this.backButton = new JButton("Back");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultViewer.this.resultListPanel.back();
                SearchResultViewer.this.validate();
            }
        });
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultViewer.this.resultListPanel.next();
                SearchResultViewer.this.validate();
            }
        });
        this.buttonPanel.add(this.backButton);
        this.buttonPanel.add(this.nextButton);
        mainPanel.add((Component)this.buttonPanel, "South");
    }
}

