/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.SegfoFileFilter;

public class SaveLineSegmentsInSegfoFormatAction
implements ActionListener {
    private LineSegEditor editor;
    private Spread spread;
    private String file_name;
    private JFileChooser chooser;

    public SaveLineSegmentsInSegfoFormatAction(LineSegEditor parent) {
        this.editor = parent;
        this.spread = this.editor.getSpread();
        this.file_name = this.spread.getFileName();
        this.chooser = new JFileChooser(Preference.getInstance().getImageFolderPathString() + this.spread.getFolderPath());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int ans;
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setFileFilter(new SegfoFileFilter());
        this.chooser.setFileSelectionMode(0);
        int input = this.chooser.showOpenDialog(WorkspaceWindow.getInstance());
        if (input == 1) {
            return;
        }
        File file = this.chooser.getSelectedFile();
        if (file.exists() && (ans = JOptionPane.showConfirmDialog(this.editor, String.format("File %s exists. Overwrite?", file.toString()))) == 1) {
            return;
        }
        try {
            FileOutputStream fstream = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter(fstream);
            PrintWriter pw = new PrintWriter(out);
            pw.printf(this.file_name + "%n", new Object[0]);
            if (Preference.getInstance().getTextType() == 0) {
                pw.printf("Horizontal%n", new Object[0]);
            } else {
                pw.printf("Vertical%n", new Object[0]);
            }
            List<LineSegmentForEdit> lines = this.editor.getLinesForEdit();
            for (int i = 0; i < lines.size(); ++i) {
                LineSegmentForEdit line = lines.get(i);
                List<Point2D> points = line.getPoints();
                for (int j = 0; j < points.size(); ++j) {
                    Point2D point = points.get(j);
                    pw.printf("%6d", (int)point.getX());
                    pw.printf("%6d", (int)point.getY());
                }
                pw.printf("%6d%n", -1);
            }
            pw.printf("-99999%n", new Object[0]);
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

