/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import smart_gs.logical.GSResource;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.SpreadSelectPopupMenu;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.NewCompactEditorAction;
import smart_gs.swingui.toolbar.action.NewEditorAction;

public class SpreadTreePanel
extends JPanel
implements MouseListener {
    private SpreadTree tree;
    private JScrollPane scrollPane;

    public SpreadTreePanel() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.setAutoscrolls(true);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tree = SpreadTree.getInstance();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel tree_panel = new JPanel();
        tree_panel.setLayout(new FlowLayout(0));
        tree_panel.setBackground(Color.white);
        tree_panel.add(this.tree);
        tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.tree.addMouseListener(this);
        JPanel button_panel = new JPanel();
        JButton windowbutton1 = new JButton("Compact Editor");
        windowbutton1.addActionListener(new NewCompactEditorAction());
        button_panel.add(windowbutton1);
        JButton windowbutton2 = new JButton("Editor");
        windowbutton2.addActionListener(new NewEditorAction());
        button_panel.add(windowbutton2);
        panel.add((Component)tree_panel, "Center");
        this.scrollPane.setViewportView(panel);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)button_panel, "South");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getClickCount() == 2) {
                TreePath[] paths = this.tree.getSelectedPaths();
                if (paths == null || paths.length == 0) {
                    return;
                }
                GSResource selected = (GSResource)((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
                if (!(selected instanceof Spread)) {
                    return;
                }
                Spread spread = (Spread)selected;
                if (spread != null) {
                    File imageFile = spread.getImageFile();
                    System.out.println(imageFile);
                    if (!imageFile.exists()) {
                        JOptionPane.showMessageDialog(null, "Image File for the spread does not exist: " + imageFile.toString());
                    }
                    WorkspaceWindow.getInstance().setSpread(spread);
                }
            } else if (e.getClickCount() == 1) {
                this.tree.getSelectionModel().setSelectionMode(4);
            }
            return;
        }
        if (e.getButton() == 3) {
            SpreadSelectPopupMenu menu = new SpreadSelectPopupMenu(this.tree);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void search(String q) {
        this.startSearchTree(this.tree, this.tree.getPathForRow(0), q);
    }

    public Spread getSpreadInTree(int row) {
        List<Spread> list = this.tree.getSpreads();
        try {
            for (int i = 0; i < list.size(); ++i) {
                Spread spread = list.get(i);
                if (spread.getPageViewIndex() != row) continue;
                return spread;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public SpreadTree getTree() {
        return this.tree;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void startSearchTree(JTree tree, TreePath path, String q) {
        this.tree.clearSelection();
        this.searchTree(tree, path, q);
    }

    private void searchTree(JTree tree, TreePath path, String q) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.toString().equals(q)) {
            tree.addSelectionPath(path);
        }
        if (!node.isLeaf() && node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                this.searchTree(tree, path.pathByAddingChild(e.nextElement()), q);
            }
        }
    }
}

