/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneLayout;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.Region;
import smart_gs.swingui.WorkspaceWindow;

public class MemoPadDialog
extends JDialog {
    private JScrollPane sPane;
    private JTextArea textArea;
    private JButton ok;
    private JButton cancel;

    public MemoPadDialog(Region region) {
        super(WorkspaceWindow.getInstance());
        this.setModal(true);
        String text = ((MemoPadView)region.getView()).getMemoPadText();
        this.textArea = new JTextArea(1, 20);
        this.textArea.setText(text);
        this.sPane = new JScrollPane(this.textArea);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new OKActionListener(this, region));
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new CancelActionListener(this));
        this.build();
        if (region.getName() != "") {
            this.setTitle("MemoPad: " + region.getName());
        }
        this.setSize(300, 200);
    }

    private void build() {
        Container pane = this.getContentPane();
        pane.removeAll();
        this.setTitle("MemoPad");
        this.sPane.setLayout(new ScrollPaneLayout());
        this.getContentPane().add(this.sPane);
        this.getContentPane().add(this.ok);
        this.getContentPane().add(this.cancel);
        GroupLayout layout = new GroupLayout(pane);
        pane.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sPane).addGroup(layout.createSequentialGroup().addComponent(this.ok).addComponent(this.cancel))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sPane)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ok).addComponent(this.cancel)));
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    class CancelActionListener
    implements ActionListener {
        private MemoPadDialog dialog;

        public CancelActionListener(MemoPadDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.dialog.dispose();
        }
    }

    class OKActionListener
    implements ActionListener {
        private MemoPadDialog dialog;
        private Region region;

        public OKActionListener(MemoPadDialog dialog, Region region) {
            this.dialog = dialog;
            this.region = region;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ((MemoPadView)this.region.getView()).setMemoPadText(this.dialog.textArea.getText());
            this.dialog.dispose();
            WorkspaceWindow.setUpdated(true);
        }
    }
}

