/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import com.hexidec.ekit.GSHTMLEditorFoucsActionListner;
import com.hexidec.ekit.GSHTMLEditorSearchActionListner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.GSTabbedPaneManager;
import smart_gs.swingui.IDATNameInGSTabbedPaneManager;
import smart_gs.swingui.ToolBarPanel;
import smart_gs.swingui.WorkspaceTabbedPane;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import sml_editor.swingui.EditorTextPane;

public class GSEditor
extends AbstractGSWindow {
    public static final int COMPACT = 0;
    public static final int FULL = 1;
    private String url;
    protected int open = 0;
    protected AtomicLong id;
    private Mode mode;
    private GSTabbedPaneWindowAdapter gsTabbedPaneWindowAdapter;
    private JPanel imagePanel;
    private JTabbedPane leftPanel;
    private JSplitPane mainSplitPane;
    private JSplitPane splitPane = null;
    private JPanel textDocumentPanel;
    private JPanel allDocumentPanel;
    private ToolBarPanel toolbarpanel;
    private JLabel textDocumentStatusBar;
    private int type;
    private Spread spread;
    private SpreadCanvas canvas;

    public int getType() {
        return this.type;
    }

    public GSEditor(Spread spread, int type) {
        super("Editor: " + spread.getName());
        this.spread = spread;
        this.type = type;
        this.url = spread.getURI();
        this.tabbedPane = this.createTabbedPane(spread);
        this.canvas = this.getSMLTabbedPane().getSpreadCanvas();
        this.canvas.setGSEditor(this);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        if (this.type == 1) {
            this.enableEvents(64L);
            this.imagePanel = new JPanel(new BorderLayout());
            this.getContentPane().setLayout(new BorderLayout());
            this.textDocumentPanel = new JPanel(new BorderLayout());
            this.textDocumentPanel.add((Component)this.tabbedPane, "Center");
            this.add(this.textDocumentPanel);
        } else {
            this.allDocumentPanel = new JPanel(new BorderLayout());
            this.allDocumentPanel.add((Component)this.tabbedPane, "Center");
            this.add(this.allDocumentPanel);
        }
        this.toolbarpanel = new ToolBarPanel(this, false, Preference.windowModeIsHorizontal());
        this.toolbarpanel.getImageToolBar().enableIcons();
        this.add((Component)this.toolbarpanel, "North");
        if (this.type == 0) {
            this.setSize(780, 680);
        } else {
            this.setSize(1180, 680);
        }
        if (this.type == 1) {
            this.displayWorksapceWindow(Preference.getWorkspaceWindowMode());
        }
        this.updateGUI();
        this.id = GSTabbedPaneManager.getControlID();
        this.gsTabbedPaneWindowAdapter = new GSTabbedPaneWindowAdapter(this.url, String.valueOf(this.id), this.getSMLTabbedPane(), this);
        this.addWindowListener(this.gsTabbedPaneWindowAdapter);
        this.updateMoveToolBar();
    }

    @Override
    public void setSpread(Spread spread) {
        this.spread = spread;
        WorkspaceWindow.getInstance().save();
        if (this.tabbedPane != null) {
            this.tabbedPane.clear();
        }
        this.tabbedPane = this.type == 1 ? new WorkspaceTabbedPane(this, spread) : new GSTabbedPane(this, spread);
        this.updateGUI(spread);
        this.updateMoveToolBar();
    }

    public void updateGUI() {
        Spread spread = this.getSpread();
        if (spread != null) {
            this.updateGUI(spread);
        }
    }

    public void updateMoveToolBar() {
        MoveTreeToolBar moveTreeToolBar = this.toolbarpanel.getMoveTreeToolBar();
        if (this.tabbedPane.getSpread() != null) {
            moveTreeToolBar.setPathCount(this.tabbedPane.getSpread().getPageViewIndex());
        }
    }

    public void displayWorksapceWindow(int workspaceWindowMode) {
        switch (workspaceWindowMode) {
            case 0: {
                this.mainSplitPane = new JSplitPane(0, this.imagePanel, this.textDocumentPanel);
                this.mainSplitPane.setDividerLocation(350);
                this.mainSplitPane.setOneTouchExpandable(true);
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1000, 780);
                break;
            }
            case 1: {
                this.mainSplitPane = new JSplitPane(0, this.textDocumentPanel, this.imagePanel);
                this.mainSplitPane.setDividerLocation(350);
                this.mainSplitPane.setOneTouchExpandable(true);
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1000, 780);
                break;
            }
            case 2: {
                this.mainSplitPane = new JSplitPane(1, this.imagePanel, this.textDocumentPanel);
                this.mainSplitPane.setDividerLocation(600);
                this.mainSplitPane.setOneTouchExpandable(true);
                this.mainSplitPane.getRightComponent().setMinimumSize(new Dimension(0, 0));
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1200, 680);
                break;
            }
            case 3: {
                this.mainSplitPane = new JSplitPane(1, this.textDocumentPanel, this.imagePanel);
                this.mainSplitPane.setDividerLocation(600);
                this.mainSplitPane.setOneTouchExpandable(true);
                this.mainSplitPane.getLeftComponent().setMinimumSize(new Dimension(0, 0));
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1200, 680);
                break;
            }
            default: {
                this.mainSplitPane = new JSplitPane(1, this.imagePanel, this.textDocumentPanel);
            }
        }
        this.validate();
        this.repaint();
    }

    public static GSEditor createCompactGSEditor(Spread spread) {
        return new GSEditor(spread, 0);
    }

    public static GSEditor createFullGSEditor(Spread spread) {
        return new GSEditor(spread, 1);
    }

    public GSEditor(Spread spread, Rectangle2D rect) {
        this(spread, 0);
        RectangleView view = new RectangleView(rect);
        view.setIsEmphasized(true);
        Point point = new Point((int)rect.getX(), (int)rect.getY());
        this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
        this.tabbedPane.getSpreadCanvas().addTempView(view);
        this.updateMoveToolBar();
    }

    public GSEditor(List<SearchResult> results) {
        this(results.get(0).getSpread(), 0);
        for (int i = 0; i < results.size(); ++i) {
            Rectangle rect = results.get(i).getRectangle();
            RectangleView view = new RectangleView(rect);
            view.setIsEmphasized(true);
            this.tabbedPane.getSpreadCanvas().addTempView(view);
        }
        Point point = results.get(0).getRectangle().getLocation();
        this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
        this.updateMoveToolBar();
    }

    public GSEditor(Region region) {
        this(region.getSpread(), 0);
        View view = region.getView();
        view.setIsEmphasized(true);
        Rectangle2D rect = view.getRectangle2D();
        Point point = new Point((int)rect.getX(), (int)rect.getY());
        this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
        this.tabbedPane.getSpreadCanvas().addTempView(view);
        this.updateMoveToolBar();
    }

    public GSEditor(TextSegment segment) {
        super("Editor");
    }

    public GSEditor(String string) {
        super("Editor:" + string);
    }

    @Override
    public void setEditorTextPane(EditorTextPane textPane) {
        textPane.setSearchAction(new SearchAction(this.getGSEditorToolBar()));
        textPane.setFocusAction(new FoucsAction(this, this.getGSEditorToolBar()));
        this.tabbedPane.getGSEditorToolBar().setTextPane(textPane);
    }

    @Override
    public void setEditorToolBar(JToolBar toolbar) {
    }

    @Override
    public Spread getSpread() {
        return this.tabbedPane.getSpread();
    }

    public GSTabbedPane getSMLTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public void updateGUI(Spread spread) {
        if (this.type == 1) {
            this.textDocumentPanel.removeAll();
            Component imagePanel = this.tabbedPane.getImagePanel();
            this.imagePanel.removeAll();
            this.imagePanel.add(imagePanel);
            this.textDocumentPanel.add(this.tabbedPane);
            this.textDocumentStatusBar = new JLabel("");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.textDocumentStatusBar, "First");
            this.textDocumentPanel.add((Component)jPanel, "South");
        } else {
            this.allDocumentPanel.removeAll();
            Component imagePanel = this.tabbedPane.getImagePanel();
            this.allDocumentPanel.add(this.tabbedPane);
            this.textDocumentStatusBar = new JLabel("");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.textDocumentStatusBar, "First");
            this.allDocumentPanel.add((Component)jPanel, "South");
        }
        this.setTitle("Editor: " + spread.getName());
        this.validate();
        this.repaint();
    }

    @Override
    public SpreadCanvas getSpreadCanvas() {
        return this.tabbedPane.canvas;
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public GSTabbedPane createTabbedPane(Spread spread) {
        return new GSTabbedPane(this, spread);
    }

    public void emphasize(String id) {
        this.tabbedPane.emphasize(id);
    }

    public void updateText() {
        this.tabbedPane.updateText();
    }

    public String getURL() {
        return this.url;
    }

    public AtomicLong getControlID() {
        return this.id;
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.tabbedPane.getGSEditorToolBar();
    }

    public void setCaret(int index) {
        this.getSMLTabbedPane().setCaret(index);
    }

    public void updateWindowListener() {
        this.removeWindowListener(this.gsTabbedPaneWindowAdapter);
        this.id = GSTabbedPaneManager.getControlID();
        this.gsTabbedPaneWindowAdapter = new GSTabbedPaneWindowAdapter(this.url, String.valueOf(this.id), this.getSMLTabbedPane(), this);
        this.addWindowListener(this.gsTabbedPaneWindowAdapter);
    }

    public int isOpened() {
        return this.open;
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public GSTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setTabbedPane(GSTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    public ImageToolBar getImageToolBar() {
        return this.toolbarpanel.getImageToolBar();
    }

    private class FoucsAction
    implements GSHTMLEditorFoucsActionListner {
        protected GSEditorToolBar gsEditorToolBar;
        protected GSEditor gsEditor;

        public FoucsAction(GSEditor gsEditor, GSEditorToolBar gsEditorToolBar) {
            this.gsEditor = gsEditor;
            this.gsEditorToolBar = gsEditorToolBar;
        }

        @Override
        public void focusGained() {
            SearchAllDialogManager.setEditor(this.gsEditor, this.gsEditorToolBar);
            SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
        }

        @Override
        public void focusLost() {
        }
    }

    private class SearchAction
    implements GSHTMLEditorSearchActionListner {
        protected GSEditorToolBar gsEditorToolBar;

        public SearchAction(GSEditorToolBar gsEditorToolBar) {
            this.gsEditorToolBar = gsEditorToolBar;
        }

        @Override
        public void actionPerformed() {
            SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
            SearchDialogManager.visible();
        }
    }

    class GSTabbedPaneWindowAdapter
    extends WindowAdapter {
        protected String key;
        protected String id;
        protected GSTabbedPane gsTabbedPane;
        private AbstractGSWindow parent;

        public GSTabbedPaneWindowAdapter(String key, String id, GSTabbedPane gsTabbedPane, AbstractGSWindow parent) {
            this.key = key;
            this.id = id;
            this.gsTabbedPane = gsTabbedPane;
            this.parent = parent;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            IDATNameInGSTabbedPaneManager.unregistorGSEditorTabbedPane(this.gsTabbedPane);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SearchDialogManager.setGSEditorToolBar(GSEditor.this.getGSEditorToolBar());
            GSTabbedPane newTabbedPane = GSTabbedPaneManager.getGSTabbedPane(this.key);
            if (newTabbedPane != null) {
                String windowid = GSTabbedPaneManager.getWindowsID(this.key);
                if (windowid == null) {
                    return;
                }
                if (windowid.equals(this.key + this.id)) {
                    return;
                }
                newTabbedPane.save();
                String fstidatSource = newTabbedPane.getFirstIDATSource();
                this.gsTabbedPane.updateFirstIDAT(fstidatSource);
                String sndidatSource = newTabbedPane.getSecondIDATSource();
                this.gsTabbedPane.updateSecondIDAT(sndidatSource);
                String thrdidatSource = newTabbedPane.getThirdIDATSource();
                this.gsTabbedPane.updateThirdIDAT(thrdidatSource);
                this.gsTabbedPane.updateText();
                this.gsTabbedPane.save();
                GSTabbedPaneManager.removeGSTabbedPane(this.key);
            }
            GSEditor.this.open = 1;
            Mode mode = ((GSEditor)this.parent).getMode();
            if (mode != null) {
                DefaultState.getInstance().setMode(mode);
            }
            GSEditor.this.getTabbedPane().getFirstIDAT().setCaretPosition(0);
            GSEditor.this.getTabbedPane().getSecondIDAT().setCaretPosition(0);
            GSEditor.this.getTabbedPane().getThirdIDAT().setCaretPosition(0);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.gsTabbedPane.save();
            GSTabbedPaneManager.setGSTabbedPane(this.key, this.key + this.id, this.gsTabbedPane);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            GSEditor.this.open = 2;
            GSTabbedPaneManager.close(this.key + this.id);
        }
    }
}

