/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import reasoning_web.logical.Connection;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.swingui.view.PathView;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;

public class ConnectionView
extends PathView {
    private GSConnection connection;
    private View sourceView;
    private View targetView;

    public ConnectionView(GSConnection connection) {
        this.connection = connection;
        this.sourceView = this.connection.getSourcePointer().getView();
        this.targetView = this.connection.getTargetPointer().getView();
    }

    public View getSourceView() {
        return this.sourceView;
    }

    public View getTargetView() {
        return this.targetView;
    }

    @Override
    public void drawShape(Graphics2D g) {
        Color oldColor = g.getColor();
        this.sourceView.drawShape(g);
        this.targetView.drawShape(g);
        Rectangle srcbd = ((ResourcePointerView)this.sourceView).getShape().getBounds();
        Rectangle destbd = ((ResourcePointerView)this.targetView).getShape().getBounds();
        Point2D.Double srcCenter = new Point2D.Double(srcbd.getCenterX(), srcbd.getCenterY());
        Point2D.Double destCenter = new Point2D.Double(destbd.getCenterX(), destbd.getCenterY());
        Point2D.Double middlePoint = new Point2D.Double((((Point2D)srcCenter).getX() + ((Point2D)destCenter).getX()) / 2.0, (((Point2D)srcCenter).getY() + ((Point2D)destCenter).getY()) / 2.0);
        if (!srcbd.intersects((Rectangle2D)destbd)) {
            Point2D.Double srcPoint = (srcbd.outcode(middlePoint) & 1) != 0 ? new Point2D.Double(((RectangularShape)srcbd).getX(), ((RectangularShape)srcbd).getY() + ((RectangularShape)srcbd).getHeight() / 2.0 + ((RectangularShape)srcbd).getHeight() / 20.0 * -1.0 * 1.0) : ((srcbd.outcode(middlePoint) & 4) != 0 ? new Point2D.Double(((RectangularShape)srcbd).getX() + ((RectangularShape)srcbd).getWidth(), ((RectangularShape)srcbd).getY() + ((RectangularShape)srcbd).getHeight() / 2.0 + ((RectangularShape)srcbd).getHeight() / 20.0 * -1.0 * 1.0) : ((srcbd.outcode(middlePoint) & 2) != 0 ? new Point2D.Double(((RectangularShape)srcbd).getX() + ((RectangularShape)srcbd).getWidth() / 2.0 + ((RectangularShape)srcbd).getWidth() / 20.0 * -1.0 * 1.0, ((RectangularShape)srcbd).getY()) : new Point2D.Double(((RectangularShape)srcbd).getX() + ((RectangularShape)srcbd).getHeight() / 2.0 + ((RectangularShape)srcbd).getWidth() / 20.0 * -1.0 * 1.0, ((RectangularShape)srcbd).getY() + ((RectangularShape)srcbd).getHeight())));
            Point2D.Double destPoint = (destbd.outcode(middlePoint) & 1) != 0 ? new Point2D.Double(((RectangularShape)destbd).getX(), ((RectangularShape)destbd).getY() + ((RectangularShape)destbd).getHeight() / 2.0 + ((RectangularShape)destbd).getHeight() / 20.0 * -1.0 * 1.0) : ((destbd.outcode(middlePoint) & 4) != 0 ? new Point2D.Double(((RectangularShape)destbd).getX() + ((RectangularShape)destbd).getWidth(), ((RectangularShape)destbd).getY() + ((RectangularShape)destbd).getHeight() / 2.0 + ((RectangularShape)destbd).getHeight() / 20.0 * 1.0 * 1.0) : ((destbd.outcode(middlePoint) & 2) != 0 ? new Point2D.Double(((RectangularShape)destbd).getX() + ((RectangularShape)destbd).getWidth() / 2.0 + ((RectangularShape)destbd).getWidth() / 20.0 * -1.0 * 1.0, ((RectangularShape)destbd).getY()) : new Point2D.Double(((RectangularShape)destbd).getX() + ((RectangularShape)destbd).getHeight() / 2.0 + ((RectangularShape)destbd).getWidth() / 20.0 * -1.0 * 1.0, ((RectangularShape)destbd).getY() + ((RectangularShape)destbd).getHeight())));
            this.line = new Line2D.Double(srcPoint, destPoint);
            if (this.isSelected) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLACK);
            }
            this.drawArrow((int)((Point2D)srcPoint).getX(), (int)((Point2D)srcPoint).getY(), (int)((Point2D)destPoint).getX(), (int)((Point2D)destPoint).getY(), 10, g);
            g.setColor(oldColor);
        } else {
            this.line = null;
        }
    }

    private void drawArrow(int x0, int y0, int x1, int y1, int l, Graphics2D g) {
        double dt = 0.5235987755982988;
        double theta = Math.atan2(y1 - y0, x1 - x0);
        g.drawLine(x0, y0, x1, y1);
        int x = x1 - (int)((double)l * Math.cos(theta - dt));
        int y = y1 - (int)((double)l * Math.sin(theta - dt));
        g.drawLine(x1, y1, x, y);
        x = x1 - (int)((double)l * Math.cos(theta + dt));
        y = y1 - (int)((double)l * Math.sin(theta + dt));
        g.drawLine(x1, y1, x, y);
    }

    @Override
    public String toString() {
        return "connection";
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Rectangle2D getRectangle() {
        return null;
    }

    @Override
    public void setRectangle(double x, double y, double w, double h) {
    }

    @Override
    public void setRectangle(double x, double y) {
    }
}

