/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import reasoning_web.logical.Connection;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.Preference;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.mouse_listener.GlobalViewMouseListener;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.util.CanonicalPathString;

public class GlobalViewPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int maxX = 0;
    private int maxY = 0;
    private static GlobalViewPanel singleton = new GlobalViewPanel();
    private GlobalViewMouseListener listener = new GlobalViewMouseListener();
    private BufferedImage readImage = null;
    private float visibility = 1.0f;

    private GlobalViewPanel() {
        if (!Preference.getInstance().getRWBackgroundFilePathString().equals("")) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(new File(Preference.getInstance().getRWBackgroundFilePathString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bufferedImage != null) {
                this.setReadImage(bufferedImage);
            }
        }
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static GlobalViewPanel getInstance() {
        return singleton;
    }

    public GS_RWElement getSelectedElement() {
        return this.listener.getSelectedElement();
    }

    public void setSelectedElement(GS_RWElement element) {
        this.listener.setSelectedElement(element);
    }

    public RWElement getElement(Point point) {
        List<ResourcePointer> elements = GS_RWRepository.getInstance().getResourcePointers();
        for (int i = 0; i < elements.size(); ++i) {
            View view = ((GSResourcePointer)elements.get(i)).getView();
            if (!view.contains(point)) continue;
            return elements.get(i).getRwElement();
        }
        List<Connection> connections = GS_RWRepository.getInstance().getConnections();
        for (int i = 0; i < connections.size(); ++i) {
            View view = ((GSConnection)connections.get(i)).getView();
            if (!view.contains(point)) continue;
            return connections.get(i);
        }
        return null;
    }

    public ResourcePointer getResourcePointer(Point point) {
        List<ResourcePointer> elements = GS_RWRepository.getInstance().getResourcePointers();
        for (int i = 0; i < elements.size(); ++i) {
            View view = ((GSResourcePointer)elements.get(i)).getView();
            if (!view.contains(point)) continue;
            return elements.get(i);
        }
        return null;
    }

    public Connection getConnection(Point point) {
        List<Connection> connections = GS_RWRepository.getInstance().getConnections();
        for (int i = 0; i < connections.size(); ++i) {
            View view = ((GSConnection)connections.get(i)).getView();
            if (!view.contains(point)) continue;
            return connections.get(i);
        }
        return null;
    }

    public View getView(Point point) {
        List<ResourcePointer> elements = GS_RWRepository.getInstance().getResourcePointers();
        for (int i = 0; i < elements.size(); ++i) {
            View view = ((GSResourcePointer)elements.get(i)).getView();
            if (!view.contains(point)) continue;
            return view;
        }
        List<Connection> connections = GS_RWRepository.getInstance().getConnections();
        for (int i = 0; i < connections.size(); ++i) {
            View view = ((GSConnection)connections.get(i)).getView();
            if (!view.contains(point)) continue;
            return view;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Iterator<Connection> it = GS_RWRepository.getInstance().getConnections().iterator();
        while (it.hasNext()) {
            View view = ((GSConnection)it.next()).getView();
            view.drawShape((Graphics2D)g);
        }
        List<ResourcePointer> pointers = GS_RWRepository.getInstance().getResourcePointers();
        for (int i = 0; i < pointers.size(); ++i) {
            View view = ((GSResourcePointer)pointers.get(i)).getView();
            this.setMaxPanelSize(view);
            view.drawShape((Graphics2D)g);
        }
        this.stretchPanel(new Dimension(this.maxX, this.maxY));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.listener.mouseDragged(e);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.listener.mouseMoved(e);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.listener.mouseClicked(e);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.listener.mouseEntered(e);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.listener.mouseExited(e);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.listener.mousePressed(e);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.listener.mouseReleased(e);
        this.repaint();
    }

    public void stretchPanel(Dimension d) {
        GlobalViewPanel.getInstance().setPreferredSize(d);
        GlobalViewPanel.getInstance().invalidate();
        GlobalViewPanel.getInstance().getParent().validate();
    }

    public void setGlobalViewPanelSize(Point2D point) {
        int x = (int)point.getX();
        int y = (int)point.getY();
        int globalx = GlobalViewPanel.getInstance().getWidth();
        int globaly = GlobalViewPanel.getInstance().getHeight();
        if (x >= globalx && y < globaly) {
            Dimension d = new Dimension(x + 20, globaly);
            GlobalViewPanel.getInstance().stretchPanel(d);
        } else if (x < globalx && y >= globaly) {
            Dimension d = new Dimension(globalx, y + 20);
            GlobalViewPanel.getInstance().stretchPanel(d);
        } else if (x >= globalx && y >= globaly) {
            Dimension d = new Dimension(x + 20, y + 20);
            GlobalViewPanel.getInstance().stretchPanel(d);
        }
    }

    public void setMaxPanelSize(View view) {
        int x = (int)view.getRectangle().getMaxX();
        int y = (int)view.getRectangle().getMaxY();
        if (x > this.maxX) {
            this.maxX = x + 200;
        }
        if (y > this.maxY) {
            this.maxY = y + 100;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(3, this.visibility));
        g2.drawImage((Image)this.readImage, 0, 0, null);
        super.paintComponent(g2);
    }

    public void setBackground(File file) {
        try {
            this.setReadImage(ImageIO.read(file));
            GS_RWRepository.getInstance().setBackgroundFilePath(CanonicalPathString.get(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReadImage(BufferedImage image) {
        this.readImage = image;
        if (this.readImage != null) {
            if (this.maxX < this.readImage.getWidth()) {
                this.maxX = this.readImage.getWidth();
            }
            if (this.maxY < this.readImage.getHeight()) {
                this.maxY = this.readImage.getHeight();
            }
        }
        this.repaint();
    }

    public void setVisibility(float v) {
        this.visibility = v;
        this.repaint();
    }
}

