/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import reasoning_web.logical.ExplanatoryNote;
import smart_gs.logical.ConvertGS;
import smart_gs.logical.GSResource;
import smart_gs.logical.TextSegment;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;

public class GSExplanatoryNote
extends ExplanatoryNote
implements GS_RWElement {
    public GSExplanatoryNote(String source, String uri, String originalURI, String version) {
        super(source, uri, originalURI, version);
    }

    public GSExplanatoryNote(String source) {
        super(source);
    }

    public GSEditorTextPane createText() {
        String xml = this.getSource();
        if (xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")) {
            this.source = xml.substring("<xml><html>".length(), xml.length() - "</html><xml>".length());
        }
        GSEditorTextPane textPane = new GSEditorTextPane(this, this.source);
        textPane.setMarkup(false);
        textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
        textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
        return textPane;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public GSResource getTextSegmentByURI(String uri) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (!((TextSegment)this.segments.get(i)).getURI().equals(uri)) continue;
            System.out.println("return segments.get(" + i + ")");
            return (GSResource)this.segments.get(i);
        }
        System.out.println("return null");
        return null;
    }

    public static GSExplanatoryNote restore(Element noteElement) {
        String uri = noteElement.getAttribute("uri");
        String originalURI = noteElement.getAttribute("originalURI");
        String version = noteElement.getAttribute("version");
        int id = new Integer(noteElement.getAttribute("id"));
        GSExplanatoryNote note = null;
        note = ExpNoteManager.getInstance().getExplanatoryNote(id);
        if (note == null) {
            String source = noteElement.getAttribute("source");
            if (!source.startsWith("<xml><html>")) {
                try {
                    ConvertGS convertGS = new ConvertGS(source);
                    source = convertGS.parser();
                    source = source.equals("") ? "<xml><html></html></xml>" : "<xml><html>" + source + "</html></xml>";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String name = noteElement.getAttribute("name");
            note = new GSExplanatoryNote(source, uri, originalURI, version);
            note.setName(name);
            NodeList list = noteElement.getElementsByTagName("segment");
            for (int i = 0; i < list.getLength(); ++i) {
                TextSegment segment = TextSegment.restore((Element)list.item(i));
                note.addTextSegment(segment);
                segment.setSmartDocument(note);
            }
        }
        return note;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

