/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical.region;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.view.PolygonView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class PolygonRegion
extends Region {
    public PolygonRegion(Spread spread, List<Point2D> points, String uri, String originalURI) {
        super(spread, "polygon");
        this.points = points;
        this.createView();
        this.setURIs(uri, originalURI);
    }

    public PolygonRegion(Spread spread, List<Point2D> points) {
        super(spread, "polygon");
        this.points = points;
        this.createView();
        this.setURIs();
    }

    private void createView() {
        ArrayList<ExLine2D> lines = new ArrayList<ExLine2D>();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D start = (Point2D)this.points.get(i);
            Point2D end = (Point2D)this.points.get(i + 1);
            ExLine2D line = new ExLine2D(start, end);
            lines.add(line);
        }
        this.view = new PolygonView(lines);
    }

    @Override
    public Spread getSpread() {
        return this.spread;
    }

    @Override
    public List<Point2D> getPoints() {
        return this.points;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public String getTypeString() {
        return "polygon";
    }
}

