/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteTree;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.logical.visitor.Visitor;

public class UsersNoteDirectory
extends GSResource {
    private List<GSResource> resources;
    private UsersNoteDirectory parent;

    public UsersNoteDirectory() {
        this.setName(this.name);
        this.parent = null;
        this.resources = new ArrayList<GSResource>();
        this.setURIs();
    }

    public UsersNoteDirectory(UsersNoteDirectory parent, String name, String uri, String originalURI, String version) {
        this.setName(name);
        this.parent = parent;
        this.resources = new ArrayList<GSResource>();
        this.uri = uri;
        this.originalURI = originalURI;
        this.setVersion(version);
    }

    public UsersNoteDirectory(UsersNoteDirectory parent, String name) {
        this.setName(name);
        this.parent = parent;
        this.resources = new ArrayList<GSResource>();
        this.setURIs();
    }

    public List<GSResource> getResources() {
        return this.resources;
    }

    public void setResources(List<GSResource> newResources) {
        this.resources = newResources;
    }

    public List<UsersNote> getUsersNotes() {
        ArrayList<UsersNote> results = new ArrayList<UsersNote>();
        for (int i = 0; i < this.resources.size(); ++i) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof UsersNote) {
                results.add((UsersNote)resource);
                continue;
            }
            if (!(resource instanceof UsersNoteDirectory)) continue;
            results.addAll(((UsersNoteDirectory)resource).getUsersNotes());
        }
        return results;
    }

    public List<UsersNoteDirectory> getUsersNoteDirectories() {
        ArrayList<UsersNoteDirectory> results = new ArrayList<UsersNoteDirectory>();
        for (int i = 0; i < this.resources.size(); ++i) {
            GSResource resource = this.resources.get(i);
            if (!(resource instanceof UsersNoteDirectory)) continue;
            results.add((UsersNoteDirectory)resource);
            results.addAll(((UsersNoteDirectory)resource).getUsersNoteDirectories());
        }
        return results;
    }

    public void addResource(GSResource resource) {
        this.resources.add(resource);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getPath() {
        String path = "";
        if (this.parent == null) {
            return path;
        }
        path = this.parent.getPath();
        return path + this.getName() + "/";
    }

    public void restore(Element element) {
        this.resources.clear();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            String tagname = elem.getNodeName();
            if (tagname.equals("usersNote")) {
                UsersNote UsersNote2 = XML2ResourceConverter.getUsersNote(elem);
                UsersNoteTree.getInstance().registorUsersNote(UsersNote2);
                UsersNote2.setDirectory(this);
                this.addResource(UsersNote2);
                continue;
            }
            if (!tagname.equals("usersNoteDirectory")) continue;
            String name = elem.getAttribute("name");
            String uri = elem.getAttribute("uri");
            String originalURI = elem.getAttribute("originalURI");
            String version = elem.getAttribute("version");
            UsersNoteDirectory directory = new UsersNoteDirectory(this, name, uri, originalURI, version);
            UsersNoteTree.getInstance().registorUsersNoteDirectory(directory);
            this.addResource(directory);
            directory.setURI(uri);
            directory.restore(elem);
        }
    }

    public void setTree(DefaultMutableTreeNode parent) {
        for (int i = 0; i < this.resources.size(); ++i) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof UsersNote) {
                parent.add(new DefaultMutableTreeNode(resource));
                continue;
            }
            if (!(resource instanceof UsersNoteDirectory)) continue;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(resource);
            parent.add(newNode);
            ((UsersNoteDirectory)resource).setTree(newNode);
        }
    }

    public void remove(UsersNote UsersNote2) {
        for (int i = 0; i < this.resources.size(); ++i) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof UsersNote) {
                if (!resource.getURI().equals(UsersNote2.getURI())) continue;
                this.resources.remove(i);
                break;
            }
            if (!(resource instanceof UsersNoteDirectory)) continue;
            ((UsersNoteDirectory)resource).remove(UsersNote2);
        }
    }

    public void removeDirectory(UsersNoteDirectory UsersNoteDirectory2) {
        for (int i = 0; i < this.resources.size(); ++i) {
            GSResource resource = this.resources.get(i);
            if (!(resource instanceof UsersNoteDirectory)) continue;
            if (resource.getURI().equals(UsersNoteDirectory2.getURI())) {
                this.resources.remove(i);
                break;
            }
            ((UsersNoteDirectory)resource).removeDirectory(UsersNoteDirectory2);
        }
    }

    public void removeAllChildren() {
        for (int i = 0; i < this.resources.size(); ++i) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof UsersNote) {
                this.resources.remove(i);
                continue;
            }
            if (!(resource instanceof UsersNoteDirectory)) continue;
            ((UsersNoteDirectory)resource).removeAllChildren();
            this.resources.remove(i);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void sort() {
        Collections.sort(this.resources, new Comparator<GSResource>(){

            @Override
            public int compare(GSResource o1, GSResource o2) {
                if (o1 instanceof UsersNote && o2 instanceof UsersNote) {
                    if (((UsersNote)o1).getPageViewIndex() > ((UsersNote)o2).getPageViewIndex()) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "usersNoteDirectory";
    }

    public UsersNoteDirectory getParent() {
        return this.parent;
    }

    public void clear() {
        this.resources.clear();
    }
}

