/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.TextType;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.image_search.normal.swingui.ShowQueryAction;
import smart_gs.logical.Preference;

public class BucketPanel
extends JPanel
implements Observer {
    private QueryBucket bucket;
    private JFrame parent;

    public BucketPanel(JFrame parent, QueryBucket bucket) {
        this.parent = parent;
        this.bucket = bucket;
        this.bucket.addObserver(this);
        if (Preference.getInstance().getTextType() == 0) {
            this.setMaximumSize(new Dimension(600, 800));
        } else {
            this.setMaximumSize(new Dimension(800, 600));
        }
        this.updateGUI();
    }

    public void updateGUI() {
        this.removeAll();
        if (this.bucket.size() < 1) {
            return;
        }
        GSQuery query0 = this.bucket.get(0);
        if (TextType.isHorizontal()) {
            this.setLayout(new GridLayout(0, 3));
        } else {
            this.setLayout(new GridLayout(3, 0));
        }
        for (int i = 0; i < this.bucket.size(); ++i) {
            GSQuery query = this.bucket.get(i);
            Image image = i == 0 ? query.getQueryImageWithTransformation() : query.getQueryImage();
            int height = image.getHeight(null);
            int width = image.getWidth(null);
            if (TextType.isHorizontal() && height > 50) {
                double ratio2 = 50.0 / (double)height;
                width = (int)((double)width * ratio2);
                height = (int)((double)height * ratio2);
            } else if (!TextType.isHorizontal() && width > 50) {
                double ratio2 = 50.0 / (double)width;
                width = (int)((double)width * ratio2);
                height = (int)((double)height * ratio2);
            }
            image = image.getScaledInstance(width, height, 2);
            JLabel label = new JLabel(new ImageIcon(image));
            label.addMouseListener(new ShowQueryAction(query));
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.BLACK));
            panel.add(label);
            this.add(panel);
        }
        this.parent.validate();
        this.parent.toFront();
        this.parent.pack();
    }

    @Override
    public void update() {
        this.updateGUI();
    }

    public QueryBucket getBucket() {
        return this.bucket;
    }
}

