/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import smart_gs.image_search.MultiSearchAction;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.normal.swingui.BucketPanel;
import smart_gs.image_search.normal.swingui.SearchResultViewer;
import smart_gs.logical.Spread;
import smart_gs.logical.StandardTextDocument;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.CreateShortCutDialog;

public class BucketFrame
extends ButtonFrame {
    private BucketPanel bucketPanel;
    private List<SearchResult> previousResults;
    private List<SearchResult> removedResults;
    private int previousSize;
    private SetScopePanel scopePanel;

    public BucketFrame(QueryBucket bucket) {
        this(bucket, null, "Query Bucket");
    }

    public BucketFrame(QueryBucket bucket, String title, List<SearchResult> results, List<SearchResult> removedResults, int size) {
        this(bucket, null, title);
        this.previousResults = results;
        this.previousSize = size;
        this.setRemovedResults(removedResults);
    }

    public BucketFrame(QueryBucket bucket, Frame parent, String title) {
        super(parent, title);
        JScrollPane scrollPane = new JScrollPane();
        this.bucketPanel = new BucketPanel(this, bucket);
        this.okButton.setText("Search");
        scrollPane.setViewportView(this.bucketPanel);
        this.getContentPane().add((Component)scrollPane, "Center");
        JButton register = new JButton("Register");
        register.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BucketFrame.this.register();
            }
        });
        this.getButtonPanel().add((Component)register, 1);
        this.scopePanel = new SetScopePanel(true);
        this.getButtonPanel().add(this.scopePanel);
    }

    public void setRemovedResults(List<SearchResult> removedResults) {
        this.removedResults = removedResults;
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public void register() {
        QueryBucket bucket = this.bucketPanel.getBucket();
        CreateShortCutDialog dialog = new CreateShortCutDialog(this);
        dialog.setVisible(true);
        String name = dialog.getName();
        StandardTextDocument doc = dialog.getDocument();
        ShortCut shortcut = new ShortCut(bucket, name, doc);
        ReasoningWebDesktop.getInstance().getRootFolder().add(shortcut);
    }

    @Override
    public void ok() {
        ArrayList<SearchResult> pResults = new ArrayList<SearchResult>();
        for (int i = 0; i < this.previousResults.size(); ++i) {
            if (this.removedResults.contains(this.previousResults.get(i))) continue;
            this.previousResults.get(i).setWasShown(true);
            pResults.add(this.previousResults.get(i));
        }
        List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
        QueryBucket bucket = this.bucketPanel.getBucket();
        System.out.println("images to search: " + spreads);
        MultiSearchAction action = new MultiSearchAction(bucket, this.scopePanel.getDSCSpreads(spreads));
        if (pResults != null) {
            action.setPreviousResults(pResults, this.previousSize);
        }
        action.execute();
        new SearchResultViewer(bucket, action.getResults(), this.scopePanel.getSelectedPage()).setVisible(true);
        this.dispose();
    }
}

