/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.LineSegEditorImageLabel;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.View;
import smart_gs.image_search.logical.TextType;

public class LineSegView
extends View {
    Color LineSegmentDefaultColor = new Color(0, 0, 80, 80);
    private List<LineView> lineviews = new ArrayList<LineView>();
    private int index;
    private IndexView indexView;

    public LineSegView(int index) {
        this.defaultColor = this.LineSegmentDefaultColor;
        this.selectionColor = Color.red;
        this.index = index;
    }

    public LineSegView(List<ExLine2D> exLines, int index) {
        for (int i = 0; i < exLines.size(); ++i) {
            this.lineviews.add(new LineView(exLines.get(i)));
        }
        if (exLines.size() > 0) {
            this.lineviews.add(new LineView(new ExLine2D(exLines.get(exLines.size() - 1).getP2(), exLines.get(0).getP1())));
        }
        this.defaultColor = this.LineSegmentDefaultColor;
        this.selectionColor = Color.red;
        this.index = index;
        if (this.lineviews.size() != 0) {
            this.createIndexView(index);
        }
    }

    public LineSegView(List<ExLine2D> lines, boolean isSelected, boolean isEmphasized, boolean isProtected, int index) {
        this(lines, index);
        this.isSelected = isSelected;
        this.isEmphasized = isEmphasized;
        this.isProtected = isProtected;
    }

    public LineSegView(List<ExLine2D> exLines) {
        for (int i = 0; i < exLines.size(); ++i) {
            this.lineviews.add(new LineView(exLines.get(i)));
        }
        this.lineviews.add(new LineView(new ExLine2D(exLines.get(exLines.size() - 1).getP2(), exLines.get(0).getP1())));
        this.defaultColor = this.LineSegmentDefaultColor;
        this.selectionColor = Color.red;
    }

    @Override
    public boolean contains(Point2D point) {
        int[] xpoints = new int[this.lineviews.size()];
        int[] ypoints = new int[this.lineviews.size()];
        for (int i = 0; i < this.lineviews.size(); ++i) {
            xpoints[i] = (int)this.lineviews.get(i).getLine().getP1().getX();
            ypoints[i] = (int)this.lineviews.get(i).getLine().getP1().getY();
        }
        Polygon polygon = new Polygon(xpoints, ypoints, this.lineviews.size());
        return polygon.contains(point);
    }

    public void addLineView(LineView line) {
        this.lineviews.add(line);
    }

    @Override
    public void drawShape(Graphics2D g) {
        for (int i = 0; i < this.lineviews.size(); ++i) {
            this.lineviews.get(i).drawShape(g);
        }
    }

    public void drawShapeForImageLabel(Graphics2D g, ImageLabel.Show mode) {
        if (mode == ImageLabel.Show.LINE_AND_INDEX) {
            this.drawShape(g);
            this.indexView.drawShape(g);
        } else if (mode == ImageLabel.Show.LINE) {
            this.drawShape(g);
        }
    }

    public void drawShapeForLineSegImageLabel(Graphics2D g, LineSegEditorImageLabel.Show lineSegShowingMode) {
        if (lineSegShowingMode == LineSegEditorImageLabel.Show.LINE_AND_INDEX) {
            this.drawShape(g);
            this.indexView.drawShape(g);
        } else if (lineSegShowingMode == LineSegEditorImageLabel.Show.LINE) {
            this.drawShape(g);
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getTypeString() {
        return "linesegment";
    }

    @Override
    public void moveBy(Point2D d) {
        for (int i = 0; i < this.lineviews.size(); ++i) {
            this.lineviews.get(i).moveBy(d);
        }
    }

    @Override
    public View enlargedView(double ratio, double gapX, double gapY) {
        ArrayList<ExLine2D> newLines = new ArrayList<ExLine2D>();
        for (int i = 0; i < this.lineviews.size(); ++i) {
            LineView line = this.lineviews.get(i);
            line = (LineView)line.enlargedView(ratio, gapX, gapY);
            newLines.add(line.getLine());
        }
        return new LineSegView(newLines, this.isSelected, this.isEmphasized, this.isProtected, this.index);
    }

    @Override
    public Rectangle2D getRectangle2D() {
        LineView line1 = this.lineviews.get(0);
        double minX = line1.getMinX();
        double minY = line1.getMinY();
        double maxX = line1.getMaxX();
        double maxY = line1.getMaxY();
        for (int i = 0; i < this.lineviews.size(); ++i) {
            LineView line = this.lineviews.get(i);
            if (minX > line.getMinX() || minX == -1.0) {
                minX = line.getMinX();
            }
            if (minY > line.getMinY() || minX == -1.0) {
                minY = line.getMinY();
            }
            if (maxX < line.getMaxX() || minX == -1.0) {
                maxX = line.getMaxX();
            }
            if (!(maxY < line.getMaxY()) && minX != -1.0) continue;
            maxY = line.getMaxY();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public void drawLinkedShape(Graphics2D g, Image image) {
        if (this.isSelected) {
            this.draw(g);
            return;
        }
        for (int i = 0; i < this.lineviews.size(); ++i) {
            this.lineviews.get(i).drawLinkedShape(g, image);
        }
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("view");
        element.setAttribute("type", "linesegment");
        for (int i = 0; i < this.lineviews.size(); ++i) {
            element.appendChild(this.lineviews.get(i).createXMLElement(document));
        }
        return element;
    }

    public static LineSegView restore(Element element, int index) {
        LineSegView view = new LineSegView(index);
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            String tagname;
            if (nodes.item(i).getNodeType() != 1 || !(tagname = (elem = (Element)nodes.item(i)).getNodeName()).equals("view")) continue;
            LineView line = LineView.restore(elem);
            view.addLineView(line);
        }
        return view;
    }

    @Override
    public Point getCenterPoint() {
        return new Point((int)this.getRectangle2D().getCenterX(), (int)this.getRectangle2D().getCenterY());
    }

    @Override
    public String getTypeStringForDisplay() {
        return "LineSegment";
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    private void createIndexView(int index) {
        this.indexView = TextType.isHorizontal() ? new IndexView(index, this.getMinX(), this.getMinY()) : new IndexView(index, this.getMaxX() - 5, this.getMinY());
    }

    private int getMinY() {
        int minY = (int)this.lineviews.get(0).getMinY();
        for (int i = 0; i < this.lineviews.size(); ++i) {
            if (minY <= (int)this.lineviews.get(i).getMinY()) continue;
            minY = (int)this.lineviews.get(i).getMinY();
        }
        return minY;
    }

    private int getMinX() {
        int minX = (int)this.lineviews.get(0).getMinX();
        for (int i = 0; i < this.lineviews.size(); ++i) {
            if (minX <= (int)this.lineviews.get(i).getMinX()) continue;
            minX = (int)this.lineviews.get(i).getMinX();
        }
        return minX;
    }

    private int getMaxX() {
        int maxX = (int)this.lineviews.get(0).getMaxX();
        for (int i = 0; i < this.lineviews.size(); ++i) {
            if (maxX >= (int)this.lineviews.get(i).getMaxX()) continue;
            maxX = (int)this.lineviews.get(i).getMaxX();
        }
        return maxX;
    }

    @Override
    public void drawLinkIcon(Graphics2D g, Image image) {
    }

    @Override
    public void drawTemporaryIcon(Graphics2D g) {
    }

    @Override
    public void drawTemporaryShape(Graphics2D g, Image image) {
    }

    private class IndexView {
        private int index;
        private int x;
        private int y;
        private Rectangle2D rectangle;

        public IndexView(int index, int x, int y) {
            this.index = index;
            this.x = x;
            this.y = y;
        }

        protected void drawShape(Graphics2D g) {
            FontMetrics fm = g.getFontMetrics();
            int h = fm.getHeight();
            int ast = fm.getAscent();
            int w = fm.stringWidth(this.index + "");
            int xx = this.x - w / 2;
            int yy = this.y - h / 2;
            this.rectangle = new Rectangle2D.Double(xx, yy, w + 10, h);
            g.setColor(new Color(204, 255, 255));
            g.fill(this.rectangle);
            g.setColor(Color.BLACK);
            g.draw(this.rectangle);
            g.drawString(this.index + "", xx + 5, yy + ast);
        }

        protected Rectangle2D getRectangle2D() {
            return this.rectangle;
        }

        protected int getIndex() {
            return this.index;
        }
    }
}

