/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.logical.Region;
import smart_gs.swingui.GSMouseEvent;

public class MultiSelectedState
implements State {
    private static MultiSelectedState singleton = new MultiSelectedState();
    private List<Region> selectedRegions = new ArrayList<Region>();

    private MultiSelectedState() {
    }

    public static MultiSelectedState getInstance() {
        return singleton;
    }

    public void addSelectedRegion(Region region) {
        this.selectedRegions.add(region);
        region.getView().setIsSelected(true);
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        for (int i = 0; i < this.selectedRegions.size(); ++i) {
            this.selectedRegions.get(i).getView().setIsEmphasized(false);
        }
        ImageLabel.setState(DefaultState.getInstance());
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
    }

    @Override
    public int getType() {
        return 2;
    }
}

