/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.logical.Preference;
import smart_gs.logical.region.MarkerRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class MarkerMode
extends DrawingModeAdapter {
    private Component startcomponent = null;
    private boolean out = false;
    private static Mode singleton = new MarkerMode();
    private Point2D start;
    private Point2D end;
    private Point2D tempStart;
    private Point2D tempEnd;
    private boolean temporary = false;

    public static Mode getInstance() {
        ((MarkerMode)singleton).reset();
        return singleton;
    }

    private void reset() {
        this.startcomponent = null;
        this.out = false;
        this.start = null;
        this.end = null;
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        if (e.getComponent() == this.startcomponent) {
            this.out = false;
            this.setCursor(canvas);
        } else {
            this.out = true;
        }
        this.setCursor(canvas);
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        ((MarkerMode)singleton).reset();
        this.startcomponent = e.getComponent();
        super.mousePressed(e, canvas);
        this.start = e.getPoint();
        this.tempStart = e.getOriginalPoint();
        this.setCursor(canvas);
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        if (e.getComponent() != this.startcomponent) {
            return;
        }
        super.mouseDragged(e, canvas);
        this.end = e.getPoint();
        this.tempEnd = e.getOriginalPoint();
        this.setCursor(canvas);
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        if (e.getComponent() != this.startcomponent) {
            this.out = true;
            return;
        }
        this.out = false;
        if (this.startcomponent != null && e.getComponent() != this.startcomponent) {
            return;
        }
        this.setCursor(canvas);
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseReleased(e, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        if (this.start.distance(this.end) > 8.0) {
            MarkerRegion reg = new MarkerRegion(canvas.getSpread(), this.start, this.end);
            reg.setTemporary(this.isTemporary());
            canvas.addRegion(reg);
        }
        this.start = null;
        this.end = null;
        this.tempStart = null;
        this.tempEnd = null;
        DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
        new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
        this.setCursor(canvas);
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        if (this.out) {
            return;
        }
        if (this.startcomponent == null) {
            return;
        }
        if (canvas.getImageLabel() != this.startcomponent) {
            return;
        }
        super.paint(g, canvas);
        if (this.tempStart == null || this.tempEnd == null) {
            return;
        }
        ImageLabel imageLabel = canvas.getImageLabel();
        double ratio = imageLabel.getRatio();
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        int iconHeight = imageLabel.getIcon().getIconHeight();
        int iconWidth = imageLabel.getIcon().getIconWidth();
        int scrollHeight = canvas.getHorizontalScrollBar().getHeight();
        int scrollWidth = canvas.getVerticalScrollBar().getWidth();
        double gapX = 0.0;
        double gapY = 0.0;
        if (iconWidth < canvasWidth) {
            gapX = (double)(canvasWidth - scrollWidth - iconWidth) / 2.0;
        }
        if (iconHeight < canvasHeight) {
            gapY = (double)(canvasHeight - scrollHeight - iconHeight) / 2.0;
        }
        Point2D.Double start = new Point2D.Double(this.tempStart.getX() / ratio, this.tempStart.getY() / ratio);
        Point2D.Double end = new Point2D.Double(this.tempEnd.getX() / ratio, this.tempEnd.getY() / ratio);
        MarkerView view = new MarkerView(start, end);
        int breadth = new Integer(Preference.getInstance().getMarkerBreadth());
        view.setBreadth(breadth);
        view.enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean sw) {
        this.temporary = sw;
    }
}

