/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;

public class LineSegEditorSemiAutomaticMode
extends Frame
implements LineSegEditorMode {
    private static LineSegEditorSemiAutomaticMode singleton = new LineSegEditorSemiAutomaticMode();
    private Point2D start;
    private Point2D end;
    private List<Point2D> polygon;
    private Rectangle2D rect;
    private List<ExLine2D> lines = new ArrayList<ExLine2D>();
    private List<ExLine2D> separateLines;
    private LineSegEditor editor;
    private boolean isDrawing = false;

    public LineSegEditor getEditor() {
        return this.editor;
    }

    public void setEditor(LineSegEditor editor) {
        this.editor = editor;
    }

    private LineSegEditorSemiAutomaticMode() {
        this.polygon = new ArrayList<Point2D>();
        this.separateLines = new ArrayList<ExLine2D>();
    }

    public static LineSegEditorSemiAutomaticMode getInstance() {
        return singleton;
    }

    @Override
    public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
        if (e.getButton() != 1) {
            this.cancel();
            return;
        }
        if (!this.isDrawing) {
            this.start = e.getPoint();
            this.end = e.getPoint();
            this.polygon.add(this.start);
            this.isDrawing = true;
            return;
        }
        this.end = e.getPoint();
        this.lines.add(new ExLine2D(this.start, this.end));
        this.polygon.add(this.end);
        this.start = this.end;
        if (e.getClickCount() == 2) {
            this.automaticSeparation(canvas);
            this.isDrawing = false;
            this.lines = new ArrayList<ExLine2D>();
            this.polygon = new ArrayList<Point2D>();
            this.separateLines = new ArrayList<ExLine2D>();
        }
    }

    @Override
    public void mouseClicked(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    private void automaticSeparation(LineSegEditorCanvas canvas) {
        int i;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point : this.polygon) {
            if (minX > point.getX()) {
                minX = point.getX();
            }
            if (minY > point.getY()) {
                minY = point.getY();
            }
            if (maxX < point.getX()) {
                maxX = point.getX();
            }
            if (!(maxY < point.getY())) continue;
            maxY = point.getY();
        }
        this.rect = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        this.separateLines.add(new ExLine2D(new Point2D.Double(minX, minY), new Point2D.Double(maxX, minY)));
        int width = (int)this.rect.getWidth();
        int height = (int)this.rect.getHeight();
        int[] colsum = new int[height];
        Image image = this.editor.getSpread().getImage();
        PixelGrabber pg = new PixelGrabber(image, (int)minX, (int)minY, width, height, true);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] px = (int[])pg.getPixels();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = px[y * width + x];
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int n = y;
                colsum[n] = colsum[n] + (red + green + blue);
            }
        }
        int[] smoothed = new int[height];
        for (i = 2; i < height - 2; ++i) {
            smoothed[i] = (colsum[i - 2] + colsum[i - 1] + colsum[i] + colsum[i + 1] + colsum[i + 2]) / 5;
        }
        for (i = 2; i < height - 2; ++i) {
            colsum[i] = smoothed[i];
        }
        double avgcolsum = 0.0;
        for (int x = 0; x < height; ++x) {
            avgcolsum += (double)colsum[x];
        }
        avgcolsum /= (double)height;
        int maxcolsum = Integer.MAX_VALUE;
        int maxcolidx = -1;
        int prevzeroup = -1;
        int MINWIDTH = 0;
        for (int i2 = 1; i2 < height; ++i2) {
            if (colsum[i2] > maxcolsum) {
                maxcolsum = colsum[i2];
                maxcolidx = i2;
            }
            if (!((double)colsum[i2 - 1] < avgcolsum) || !((double)colsum[i2] >= avgcolsum) || i2 <= prevzeroup + MINWIDTH) continue;
            prevzeroup = i2;
            if (maxcolidx > 0) {
                int scaledy = (int)(minY + (double)maxcolidx);
                Point2D.Double p1 = new Point2D.Double(minX, scaledy);
                Point2D.Double p2 = new Point2D.Double(maxX, scaledy);
                ArrayList<Point2D> autoLinePolygon = new ArrayList<Point2D>();
                autoLinePolygon.add(this.separateLines.get(this.separateLines.size() - 1).getP1());
                autoLinePolygon.add(this.separateLines.get(this.separateLines.size() - 1).getP2());
                autoLinePolygon.add(p2);
                autoLinePolygon.add(p1);
                int nextIndex = canvas.getLines().size();
                this.editor.pushLinestack();
                canvas.addLineSegmentForEdit(new LineSegmentForEdit(autoLinePolygon, nextIndex));
                this.separateLines.add(new ExLine2D(p1, p2));
            }
            maxcolsum = 0;
        }
        ArrayList<Point2D> autoLinePolygon = new ArrayList<Point2D>();
        autoLinePolygon.add(this.separateLines.get(this.separateLines.size() - 1).getP1());
        autoLinePolygon.add(this.separateLines.get(this.separateLines.size() - 1).getP2());
        autoLinePolygon.add(new Point2D.Double(maxX, maxY));
        autoLinePolygon.add(new Point2D.Double(minX, maxY));
        int nextIndex = canvas.getLines().size();
        this.editor.pushLinestack();
        canvas.addLineSegmentForEdit(new LineSegmentForEdit(autoLinePolygon, nextIndex));
    }

    @Override
    public void mouseMoved(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
        this.end = e.getPoint();
        this.setCursor(canvas);
    }

    @Override
    public void paint(Graphics g, LineSegEditorCanvas canvas) {
        double ratio = canvas.getLineSegEditorImageLabel().getRatio();
        double gapX = canvas.getLineSegEditorImageLabel().getGapWidth();
        double gapY = canvas.getLineSegEditorImageLabel().getGapHeight();
        for (int i = 0; i < this.lines.size(); ++i) {
            ExLine2D line = this.lines.get(i);
            new LineView(line).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
        }
        if (this.isDrawing) {
            new LineView(new ExLine2D(this.start, this.end)).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
        }
        this.setCursor(canvas);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    @Override
    public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    @Override
    public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    @Override
    public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
        this.setCursor(canvas);
    }

    public void setCursor(LineSegEditorCanvas canvas) {
        canvas.getLineSegEditorImageLabel().setCursor(new Cursor(1));
    }
}

