/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.action;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.logical.Region;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.logical.LinkRemover;
import smart_gs.swingui.WorkspaceWindow;

public class DeleteRegionAction {
    private List<Region> regions = new ArrayList<Region>();
    private State state;

    private DeleteRegionAction() {
    }

    public DeleteRegionAction(Region region) {
        this();
        this.regions.add(region);
    }

    public DeleteRegionAction(Region region, State state) {
        this();
        this.regions.add(region);
        this.state = state;
    }

    public DeleteRegionAction(List<Region> regions) {
        this();
        this.regions = regions;
    }

    public void execute() {
        if (this.regions.get(0) != null) {
            for (int i = 0; i < this.regions.size(); ++i) {
                if (this.regions.get(i).isProtected().equals("normal")) {
                    Region region = this.regions.get(i);
                    this.regions.get(i).getSpread().removeRegion(region);
                    GS_RWRepository.getInstance().deleteResourceFromBaskets(region);
                    GSResourcePointer grp = GS_RWRepository.getInstance().getResourcePointer(region);
                    if (grp != null) {
                        LinkRemover.removeLinksOf(grp.getURI());
                    }
                    DefaultState state = DefaultState.getInstance();
                    ImageLabel.setState(state);
                    WorkspaceWindow.setUpdated(true);
                    continue;
                }
                JOptionPane.showMessageDialog(new JFrame(), "This markup is protected.", "Cannot delete", 1);
            }
            this.regions.clear();
        }
    }
}

