/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool;

import java.awt.Point;
import java.util.List;
import javax.swing.ImageIcon;
import smart_gs.drawing_tool.DrawableCanvas;
import smart_gs.drawing_tool.LineSegEditorImageLabel;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;

public class LineSegEditorCanvas
extends DrawableCanvas {
    private Spread spread;
    private LineSegEditorImageLabel lsgImageLabel;
    private ImageIcon imageIcon;

    public LineSegEditorCanvas(Spread spread) {
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.getHorizontalScrollBar().setUnitIncrement(20);
        this.spread = spread;
        this.imageIcon = spread.getImageIcon();
        this.lsgImageLabel = new LineSegEditorImageLabel(this, this.imageIcon);
        this.setViewportView(this.lsgImageLabel);
    }

    public Point getCornerPoint() {
        return this.getCornerPoint();
    }

    public Spread getSpread() {
        return this.spread;
    }

    public LineSegEditorImageLabel getLineSegEditorImageLabel() {
        return this.lsgImageLabel;
    }

    public void addTempView(View view) {
        this.lsgImageLabel.addTempView(view);
    }

    public void zoomIn() {
        this.lsgImageLabel.zoomIn();
    }

    public void zoomOut() {
        this.lsgImageLabel.zoomOut();
    }

    public void fullSize() {
        this.lsgImageLabel.fullSize();
    }

    public void fitWidth() {
        this.lsgImageLabel.fitWidth(this.getWidth());
    }

    public void fitHeight() {
        this.lsgImageLabel.fitHeight(this.getHeight());
    }

    public void setCenterLocation(Point point) {
        this.lsgImageLabel.setCenterLocation(point);
    }

    public void clear() {
        this.getViewport().removeAll();
        this.getCurrentSpread().release();
    }

    public void setCurrentSpread(Spread currentSpread) {
        this.spread = currentSpread;
    }

    public Spread getCurrentSpread() {
        return this.spread;
    }

    public List<LineSegmentForEdit> getLines() {
        return this.getLineSegEditorImageLabel().getLines();
    }

    public void setLines(List<LineSegmentForEdit> lines) {
        this.getLineSegEditorImageLabel().setLines(lines);
    }

    public void rewriteLineSegIndexes() {
        this.getLineSegEditorImageLabel().rewriteLinesSegIndexes();
    }

    public void addLineSegmentForEdit(LineSegmentForEdit LineSegmentForEdit2) {
        this.getLineSegEditorImageLabel().addLineSegmentForEdit(LineSegmentForEdit2);
    }
}

