/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.LineSegView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;

public class ImageLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private final int DEFAULT_WIDTH = 1200;
    private final int ZOOM_VALUE = 200;
    public int scale = 0;
    private static State state;
    private static boolean isLineShown;
    private static boolean isRectangleShown;
    private Show lineSegShowingMode = Show.NEITHER;
    private SpreadCanvas canvas;
    private Spread spread;
    private ImageIcon imageIcon;
    private int currentWidth;
    private int currentHeight;
    private int imageWidth;
    private int imageHeight;
    private Image image;
    private List<View> tempViews;
    private final Rectangle rect = new Rectangle();
    private Point2D start = null;
    private Point2D end = null;

    public ImageLabel(SpreadCanvas canvas, ImageIcon imageIcon) {
        super(imageIcon);
        this.canvas = canvas;
        this.spread = this.canvas.getSpread();
        this.imageIcon = imageIcon;
        this.setImageWidth(this.imageIcon.getIconWidth());
        this.setImageHeight(this.imageIcon.getIconHeight());
        this.image = this.imageIcon.getImage();
        this.tempViews = new ArrayList<View>();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.showImage();
        this.setLayout(new FlowLayout(0));
    }

    public SpreadCanvas getSpreadCanvas() {
        return this.canvas;
    }

    public void showImage() {
        double ratio = (double)this.getImageWidth() / (double)this.getImageHeight();
        int w = 1200 + this.scale * 200;
        this.setCurrentWidth(w);
        this.setCurrentHeight((int)((double)w / ratio));
        BufferedImage bufImage = new BufferedImage(this.getCurrentWidth(), this.getCurrentHeight(), 1);
        Graphics offg = bufImage.getGraphics();
        offg.drawImage(this.image, 0, 0, this.getCurrentWidth(), this.getCurrentHeight(), this);
        this.setSize(this.getCurrentWidth(), this.getCurrentHeight());
        this.setIcon(new ImageIcon(bufImage));
        WorkspaceWindow.getInstance().getImageToolBar().enableIcons();
    }

    public Point getCornerPoint() {
        return this.getLocation();
    }

    public void zoomIn() {
        if (this.scale < 21) {
            ++this.scale;
            this.showImage();
        }
    }

    public void zoomOut() {
        if (this.scale > -5) {
            --this.scale;
            this.showImage();
        }
    }

    public void fullSize() {
        this.scale = 0;
        this.showImage();
    }

    public void fitWidth(int width) {
        this.scale = (width - 1200) / 200 - 1;
        this.showImage();
    }

    public void fitHeight(int height) {
        double ratio = (double)this.getImageWidth() / (double)this.getImageHeight();
        this.scale = (int)((ratio * (double)height - 1200.0) / 200.0 - 1.0);
        this.showImage();
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public void paint(Graphics g) {
        View view;
        int i;
        List<LineSegment> lines;
        super.paint(g);
        int width = this.spread.getWidth();
        int w = 1200 + this.scale * 200;
        double ratio = (double)w / (double)width;
        List<Region> regions = this.spread.getRegions();
        int canvasWidth = this.canvas.getWidth();
        int canvasHeight = this.canvas.getHeight();
        int iconHeight = this.getIcon().getIconHeight();
        int iconWidth = this.getIcon().getIconWidth();
        int scrollHeight = this.canvas.getHorizontalScrollBar().getHeight();
        int scrollWidth = this.canvas.getVerticalScrollBar().getWidth();
        double gapX = 0.0;
        double gapY = 0.0;
        if (iconWidth < canvasWidth) {
            gapX = (double)(canvasWidth - scrollWidth - iconWidth) / 2.0;
        }
        if (iconHeight < canvasHeight) {
            gapY = (double)(canvasHeight - scrollHeight - iconHeight) / 2.0;
        }
        if ((lines = this.spread.getLines()) != null) {
            for (i = 0; i < lines.size(); ++i) {
                view = (LineSegView)lines.get(i).getView().enlargedView(ratio, gapX, gapY);
                ((LineSegView)view).drawShapeForImageLabel((Graphics2D)g, this.lineSegShowingMode);
            }
        }
        for (i = 0; i < regions.size(); ++i) {
            view = regions.get(i).getView().enlargedView(ratio, gapX, gapY);
            if (GS_RWRepository.getInstance().hasLink(regions.get(i))) {
                view.drawLinkedShape((Graphics2D)g, regions.get(i).getLinkedImage());
                continue;
            }
            if (regions.get(i).isTemporary()) {
                view.drawTemporaryShape((Graphics2D)g, new ImageIcon("./icons/remove.png").getImage());
                continue;
            }
            view.draw((Graphics2D)g);
        }
        for (i = 0; i < this.tempViews.size(); ++i) {
            view = this.tempViews.get(i).enlargedView(ratio, gapX, gapY);
            view.draw((Graphics2D)g);
        }
        ImageLabel.getState().paint(g, this.canvas);
    }

    public double getGapWidth() {
        int canvasWidth = this.canvas.getWidth();
        int iconWidth = this.getIcon().getIconWidth();
        int scrollWidth = this.canvas.getVerticalScrollBar().getWidth();
        double gapX = 0.0;
        if (iconWidth < canvasWidth) {
            gapX = (double)(canvasWidth - scrollWidth - iconWidth) / 2.0;
        }
        return gapX;
    }

    public double getGapHeight() {
        int canvasHeight = this.canvas.getHeight();
        int iconHeight = this.getIcon().getIconHeight();
        int scrollHeight = this.canvas.getHorizontalScrollBar().getHeight();
        double gapY = 0.0;
        if (iconHeight < canvasHeight) {
            gapY = (double)(canvasHeight - scrollHeight - iconHeight) / 2.0;
        }
        return gapY;
    }

    public double getRatio() {
        int width = this.spread.getWidth();
        int w = 1200 + this.scale * 200;
        double ratio = (double)w / (double)width;
        return ratio;
    }

    public void addRegion(Region region) {
        View view = region.getView();
        region.setView(view);
        this.spread.addRegion(region);
    }

    public Point getAdjustedPoint(Point point) {
        double x = point.x;
        double y = point.y;
        int canvasWidth = this.canvas.getWidth();
        int canvasHeight = this.canvas.getHeight();
        int iconHeight = this.getIcon().getIconHeight();
        int iconWidth = this.getIcon().getIconWidth();
        double gapX = 0.0;
        double gapY = 0.0;
        int scrollHeight = this.canvas.getHorizontalScrollBar().getHeight();
        int scrollWidth = this.canvas.getVerticalScrollBar().getWidth();
        if (iconWidth < canvasWidth) {
            gapX = (double)(canvasWidth - scrollWidth - iconWidth) / 2.0;
        }
        if (iconHeight < canvasHeight) {
            gapY = (double)(canvasHeight - scrollHeight - iconHeight) / 2.0;
        }
        int width = this.spread.getWidth();
        int w = iconWidth;
        double ratio = (double)w / (double)width;
        Point p = new Point((int)((x -= gapX) / ratio), (int)((y -= gapY) / ratio));
        return p;
    }

    private GSMouseEvent getAdjustedMouseEvent(MouseEvent e) {
        Point p = this.getAdjustedPoint(e.getPoint());
        return new GSMouseEvent(e, p);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (ImageLabel.getState().getClass().equals(UniSelectedState.getInstance().getClass()) && ((UniSelectedState)ImageLabel.getState()).isSelectedRegionMoving()) {
            GSMouseEvent ge = this.getAdjustedMouseEvent(e);
            ImageLabel.getState().mouseDragged(ge, this.canvas);
            this.repaint();
            return;
        }
        this.end = e.getPoint();
        if (DefaultState.getInstance().getMode() == DefaultDrawingMode.getInstance()) {
            Rectangle r = this.getVisibleRect();
            this.rect.setRect((double)r.x + (-this.end.getX() + this.start.getX()), (double)r.y - this.end.getY() + this.start.getY(), r.getWidth(), r.getHeight());
            this.scrollRectToVisible(this.rect);
        }
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mouseDragged(ge, this.canvas);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mouseMoved(ge, this.canvas);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Cursor cursor = this.getCursor();
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mouseClicked(ge, this.canvas);
        this.repaint();
        this.setCursor(cursor);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mouseEntered(ge, this.canvas);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mouseExited(ge, this.canvas);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.start = e.getPoint();
        if (SwingUtilities.isRightMouseButton(e)) {
            for (int i = 0; i < this.tempViews.size(); ++i) {
                View view = this.tempViews.get(i);
                if (!view.contains(this.getAdjustedPoint(e.getPoint()))) continue;
                RectangleRegion region = new RectangleRegion(this.canvas.getSpread(), view.getRectangle());
                this.canvas.addRegion(region);
            }
        }
        this.tempViews.clear();
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mousePressed(ge, this.canvas);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(0));
        this.start = null;
        this.end = null;
        GSMouseEvent ge = this.getAdjustedMouseEvent(e);
        ImageLabel.getState().mouseReleased(ge, this.canvas);
        this.repaint();
    }

    public static void setState(State state) {
        ImageLabel.state = state;
    }

    public static void setLineVisible(boolean isLineShown) {
        ImageLabel.isLineShown = isLineShown;
        WorkspaceWindow.getInstance().repaint();
    }

    public static boolean isLineShown() {
        return isLineShown;
    }

    public static void setRectangleVisible(Boolean isRectangleShown) {
        ImageLabel.isRectangleShown = isRectangleShown;
        WorkspaceWindow.getInstance().repaint();
    }

    public static boolean isRectangleShown() {
        return isRectangleShown;
    }

    public void setCenterLocation(Point point) {
        double ratio = this.getRatio();
        int x = (int)((double)point.x * ratio);
        int y = (int)((double)point.x * ratio);
        this.setLocation(-x + 100, -y + 100);
    }

    public void moveTo(Point point) {
        int y;
        int x;
        int locX = (int)this.getLocation().getX();
        int locY = (int)this.getLocation().getY();
        int cw = this.canvas.getWidth();
        int ch = this.canvas.getHeight();
        int sh = this.canvas.getHorizontalScrollBar().getHeight();
        int sw = this.canvas.getVerticalScrollBar().getWidth();
        int iw = this.getIcon().getIconWidth();
        int ih = this.getIcon().getIconHeight();
        double ratio = this.getRatio();
        if (iw < cw) {
            x = locX;
        } else {
            x = (int)((double)(cw / 2) - (double)point.x * ratio);
            if (x > 0) {
                x = 0;
            } else if (x < cw - (sw + iw)) {
                x = cw - (sw + iw);
            }
        }
        if (ih < ch) {
            y = locY;
        } else {
            y = (int)((double)(ch / 2) - (double)point.y * ratio);
            if (y > 0) {
                y = 0;
            } else if (y < ch - (sh + ih)) {
                y = ch - (sh + ih);
            }
        }
        int hscroll = 0;
        while (!ImageLabel.neighbor((int)this.getLocation().getX(), x)) {
            this.canvas.getHorizontalScrollBar().setValue(++hscroll);
        }
        int vscroll = 0;
        while (!ImageLabel.neighbor((int)this.getLocation().getY(), y)) {
            this.canvas.getVerticalScrollBar().setValue(++vscroll);
        }
    }

    public void moveTo(Point point, double xoffset, double yoffset) {
        int y;
        int x;
        int locX = (int)this.getLocation().getX();
        int locY = (int)this.getLocation().getY();
        int cw = this.canvas.getWidth();
        int ch = this.canvas.getHeight();
        int sh = this.canvas.getHorizontalScrollBar().getHeight();
        int sw = this.canvas.getVerticalScrollBar().getWidth();
        int iw = this.getIcon().getIconWidth();
        int ih = this.getIcon().getIconHeight();
        double ratio = this.getRatio();
        if (!(0.0 <= xoffset) || !(xoffset <= 1.0)) {
            System.out.printf("X offset for moveTo must be in %d\n", xoffset);
            return;
        }
        if (!(0.0 <= yoffset) || !(yoffset <= 1.0)) {
            System.out.printf("Y offset for moveTo must be in %d\n", yoffset);
            return;
        }
        if (iw < cw) {
            x = locX;
        } else {
            x = (int)((double)cw * xoffset - (double)point.x * ratio);
            if (x > 0) {
                x = 0;
            } else if (x < cw - (sw + iw)) {
                x = cw - (sw + iw);
            }
        }
        if (ih < ch) {
            y = locY;
        } else {
            y = (int)((double)ch * yoffset - (double)point.y * ratio);
            if (y > 0) {
                y = 0;
            } else if (y < ch - (sh + ih)) {
                y = ch - (sh + ih);
            }
        }
        int hscroll = 0;
        while (!ImageLabel.neighbor((int)this.getLocation().getX(), x)) {
            this.canvas.getHorizontalScrollBar().setValue(++hscroll);
        }
        int vscroll = 0;
        while (!ImageLabel.neighbor((int)this.getLocation().getY(), y)) {
            this.canvas.getVerticalScrollBar().setValue(++vscroll);
        }
    }

    private static boolean neighbor(int n, int m) {
        return (n - m) * (n - m) <= 1;
    }

    public void addTempView(View view) {
        this.tempViews.add(view);
    }

    public Spread getSpread() {
        return this.spread;
    }

    public void setCurrentWidth(int currentWidth) {
        this.currentWidth = currentWidth;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public void setCurrentHeight(int currentHeight) {
        this.currentHeight = currentHeight;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public static State getState() {
        return state;
    }

    public Show getLineSegShowingMode() {
        return this.lineSegShowingMode;
    }

    public void setLineSegShowingMode(Show mode) {
        this.lineSegShowingMode = mode;
    }

    public void stepLineSegShowingMode(Show mode) {
        if (mode == Show.NEITHER) {
            this.lineSegShowingMode = Show.LINE_AND_INDEX;
        } else if (mode == Show.LINE_AND_INDEX) {
            this.lineSegShowingMode = Show.LINE;
        } else if (mode == Show.LINE) {
            this.lineSegShowingMode = Show.INDEX;
        } else if (mode == Show.INDEX) {
            this.lineSegShowingMode = Show.NEITHER;
        }
    }

    public int getLineIndex(int x, int y) {
        List<LineSegment> lines = this.spread.getLines();
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                LineSegView view = (LineSegView)lines.get(i).getView();
                if (!view.contains(new Point(x, y))) continue;
                return i;
            }
        }
        return -1;
    }

    public LineSegment getLineSeg(int n) {
        List<LineSegment> lines = this.spread.getLines();
        return lines.get(n);
    }

    static {
        isLineShown = false;
        isRectangleShown = true;
        ImageLabel.setState(DefaultState.getInstance());
        isLineShown = false;
    }

    public static enum Show {
        NEITHER,
        LINE_AND_INDEX,
        LINE,
        INDEX;

    }
}

