/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary;

import com.hexidec.ekit.component.JComboBoxNoFocus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.xml.parsers.ParserConfigurationException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.dictionary.Dictionary;
import smart_gs.dictionary.DictionaryRegion;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.swingui.WorkspaceWindow;

public class DictionaryDialog
extends JDialog {
    public static final int NUMBER_OF_PAGE = 5;
    protected JDialog myDialog;
    protected ArrayList<JTextField> textList = new ArrayList();
    protected JComboBoxNoFocus jcmbFontSizeSelector;
    protected JPanel tablePanel;
    protected JScrollPane scrollpane;
    protected JPopupMenu popup;
    protected JMenuItem deleteProperty;
    protected JMenuItem rightProperty;
    protected JMenuItem leftProperty;
    protected int process_type = 0;
    protected JTextField searchField;
    protected JLabel items;
    protected JButton nextSearch;
    protected JButton previousSearch;
    protected int presentPage = 0;
    protected String choiceword = "";
    protected int choiceindex;
    protected boolean cancel = false;
    protected JCheckBox caseSensitiveBox;
    protected JCheckBox regularExpressionsBox;

    public DictionaryDialog(Frame frame, String title, boolean modal, int process_type) {
        super(frame, title, modal);
        this.process_type = process_type;
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowClosing());
        this.popup = new JPopupMenu();
        this.deleteProperty = new JMenuItem("Delete");
        this.deleteProperty.addActionListener(new DeleteListener());
        this.rightProperty = new JMenuItem("Move to the Right");
        this.rightProperty.addActionListener(new RightMovedAction());
        this.leftProperty = new JMenuItem("Move to the Left");
        this.leftProperty.addActionListener(new LeftMovedAction());
        this.popup.add(this.deleteProperty);
        this.popup.add(this.rightProperty);
        this.popup.add(this.leftProperty);
        Panel toolBarPanel = new Panel();
        toolBarPanel.setLayout(new BorderLayout());
        toolBarPanel.add((Component)this.getJToolBar(), "North");
        toolBarPanel.add((Component)this.getJToolBar2(), "South");
        this.add((Component)toolBarPanel, "North");
        this.presentPage = 0;
        this.tablePanel = this.getTable(this.presentPage, null);
        this.setResultPanel(this.tablePanel, false);
        this.myDialog = this;
    }

    public JToolBar getJToolBar() {
        JToolBar jtlbar = new JToolBar();
        this.nextSearch = new JButton(">>");
        this.nextSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryDialog.this.presentPage += 5;
                DictionaryDialog.this.research(false);
            }
        });
        this.items = new JLabel();
        this.previousSearch = new JButton("<<");
        this.previousSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryDialog.this.presentPage -= 5;
                DictionaryDialog.this.research(false);
            }
        });
        JButton jbtnSearch = new JButton("Search");
        jbtnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionaryDialog.this.presentPage = 0;
                DictionaryDialog.this.research(false);
            }
        });
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keycode = e.getKeyCode();
                if (keycode == 10) {
                    DictionaryDialog.this.presentPage = 0;
                    DictionaryDialog.this.research(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.jcmbFontSizeSelector = new JComboBoxNoFocus(new String[]{"8", "10", "12", "14", "18", "24", "32"});
        this.jcmbFontSizeSelector.setMaximumSize(this.jcmbFontSizeSelector.getPreferredSize());
        this.jcmbFontSizeSelector.setSelectedIndex(4);
        this.jcmbFontSizeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < DictionaryDialog.this.textList.size(); ++i) {
                    JTextField textField = DictionaryDialog.this.textList.get(i);
                    String sizeStr = (String)DictionaryDialog.this.jcmbFontSizeSelector.getSelectedItem();
                    textField.setFont(new Font("Serif", 0, Integer.parseInt(sizeStr)));
                    DictionaryDialog.this.tablePanel.updateUI();
                }
            }
        });
        jtlbar.add(this.previousSearch);
        jtlbar.add(this.items);
        jtlbar.add(this.nextSearch);
        jtlbar.add(this.searchField);
        jtlbar.add(jbtnSearch);
        jtlbar.addSeparator();
        jtlbar.add(this.jcmbFontSizeSelector);
        return jtlbar;
    }

    public JToolBar getJToolBar2() {
        JToolBar jtlbar = new JToolBar();
        this.caseSensitiveBox = new JCheckBox("Case sensitive");
        this.regularExpressionsBox = new JCheckBox("Regular expressions");
        jtlbar.add(this.caseSensitiveBox);
        jtlbar.add(this.regularExpressionsBox);
        return jtlbar;
    }

    public void setResultPanel(JPanel jPanel, boolean scroll) {
        JViewport view;
        Point point = null;
        if (this.scrollpane != null) {
            if (scroll) {
                view = this.scrollpane.getViewport();
                Point viewPosition = view.getViewPosition();
                point = new Point();
                point.setLocation(viewPosition.getX(), viewPosition.getY());
            }
            this.remove(this.scrollpane);
        }
        this.scrollpane = new JScrollPane(jPanel);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.setHorizontalScrollBarPolicy(32);
        if (point != null) {
            view = this.scrollpane.getViewport();
            view.setViewPosition(point);
        }
        this.add((Component)this.scrollpane, "Center");
        this.invalidate();
        this.validate();
    }

    public JPanel getTable(int start, String searchword) {
        DictionaryXML dictionaryXML;
        this.textList.clear();
        TreeMap<String, Dictionary> dictionaryMap = null;
        if (searchword == null) {
            searchword = "";
        }
        if (searchword.equals("")) {
            dictionaryXML = DictionaryXML.getInstance();
            dictionaryMap = dictionaryXML.getDictionaryMap();
        } else {
            if (!this.caseSensitiveBox.isSelected()) {
                searchword = searchword.toLowerCase();
            }
            if (this.regularExpressionsBox.isSelected()) {
                dictionaryXML = DictionaryXML.getInstance();
                dictionaryMap = dictionaryXML.getDictionaryMapByregularExpressions(searchword);
            } else {
                dictionaryXML = DictionaryXML.getInstance();
                dictionaryMap = dictionaryXML.getDictionaryMap(searchword);
            }
        }
        int maximage = 0;
        GridBagLayout layout = new GridBagLayout();
        JPanel panelBase = new JPanel();
        panelBase.setLayout(layout);
        if (start == 0) {
            this.previousSearch.setEnabled(false);
        } else {
            this.previousSearch.setEnabled(true);
        }
        if (start + 5 >= dictionaryMap.size()) {
            this.nextSearch.setEnabled(false);
        } else {
            this.nextSearch.setEnabled(true);
        }
        int star_label = start;
        if (star_label != 0) {
            star_label /= 5;
        }
        this.items.setText(star_label + 1 + "[" + (start + 1) + "-" + (start + 5) + "]" + "/" + (int)Math.ceil((double)dictionaryMap.size() / 5.0) + "[" + dictionaryMap.size() + "]");
        int fontsize = 18;
        try {
            fontsize = Integer.parseInt((String)this.jcmbFontSizeSelector.getSelectedItem());
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator<String> itr = null;
        int i = 0;
        int counter = -1;
        for (String word : dictionaryMap.keySet()) {
            if (++counter < start) continue;
            if (10 <= i) break;
            Dictionary dictionary = dictionaryMap.get(word);
            ArrayList<DictionaryRegion> list = dictionary.getDictionaryRegionList();
            if (maximage < list.size()) {
                maximage = list.size();
            }
            i += 2;
        }
        itr = dictionaryMap.keySet().iterator();
        i = 0;
        counter = -1;
        while (itr.hasNext()) {
            JPanel buttonpanel;
            Dimension size;
            JButton button;
            String word;
            word = itr.next();
            if (++counter < start) continue;
            if (10 <= i) break;
            JTextField textField = new JTextField(word, 20);
            textField.setToolTipText(word);
            textField.setFont(new Font("Serif", 0, fontsize));
            textField.addFocusListener(new TextFieldFocusListener(textField));
            GridBagLayout wordlayout = new GridBagLayout();
            JPanel wordpanel = new JPanel();
            wordpanel.setLayout(wordlayout);
            wordpanel.setBorder(new LineBorder(Color.BLACK));
            wordpanel.setBackground(Color.WHITE);
            GridBagConstraints wordgbc = new GridBagConstraints();
            wordgbc.gridx = 0;
            wordgbc.gridy = 0;
            wordgbc.fill = 1;
            wordgbc.insets = new Insets(10, 10, 10, 10);
            wordlayout.setConstraints(textField, wordgbc);
            wordpanel.add(textField);
            if (this.process_type == 0) {
                button = new JButton("delete");
                button.addActionListener(new DictonaryTextDeleteListener(word));
                size = new Dimension(100, 20);
                button.setMaximumSize(size);
                button.setMinimumSize(size);
                button.setPreferredSize(size);
                buttonpanel = new JPanel();
                buttonpanel.setBorder(new LineBorder(Color.WHITE));
                buttonpanel.setBackground(Color.WHITE);
                buttonpanel.add(button);
                wordgbc.gridx = 0;
                wordgbc.gridy = 1;
                wordgbc.fill = 1;
                wordgbc.insets = new Insets(10, 10, 10, 10);
                wordlayout.setConstraints(buttonpanel, wordgbc);
                wordpanel.add(buttonpanel);
            } else if (this.process_type == 1) {
                button = new JButton("choice");
                button.addActionListener(new SelectWordAction(word));
                size = new Dimension(100, 20);
                button.setMaximumSize(size);
                button.setMinimumSize(size);
                button.setPreferredSize(size);
                buttonpanel = new JPanel();
                buttonpanel.setBorder(new LineBorder(Color.WHITE));
                buttonpanel.setBackground(Color.WHITE);
                buttonpanel.add(button);
                wordgbc.gridx = 0;
                wordgbc.gridy = 1;
                wordgbc.fill = 1;
                wordgbc.insets = new Insets(10, 10, 10, 10);
                wordlayout.setConstraints(buttonpanel, wordgbc);
                wordpanel.add(buttonpanel);
            }
            this.textList.add(textField);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.gridwidth = 1;
            gbc.gridheight = 2;
            layout.setConstraints(wordpanel, gbc);
            panelBase.add(wordpanel);
            Dictionary dictionary = dictionaryMap.get(word);
            ArrayList<DictionaryRegion> dictionaryList = dictionary.getDictionaryRegionList();
            for (int j = 0; j < maximage; ++j) {
                JPanel labelPanel = new JPanel();
                labelPanel.setBorder(new LineBorder(Color.BLACK));
                labelPanel.setBackground(Color.WHITE);
                if (dictionaryList.size() > j) {
                    DictionaryRegion dictionaryRegion = dictionaryList.get(j);
                    Region region = dictionaryRegion.getRegion();
                    Spread spread = region.getSpread();
                    JLabel label = new JLabel(spread.getURI());
                    if (!dictionaryRegion.isSearchable()) {
                        label.setText("cannot search");
                        label.setBackground(Color.MAGENTA);
                        label.setOpaque(true);
                    }
                    labelPanel.add(label);
                }
                JPanel imagePanel = new JPanel();
                imagePanel.setBorder(new LineBorder(Color.BLACK));
                imagePanel.setBackground(Color.WHITE);
                if (dictionaryList.size() > j) {
                    DictionaryRegion dictionaryRegion = dictionaryList.get(j);
                    Region region = dictionaryRegion.getRegion();
                    try {
                        JPanel regionJPanel = region.createElementViewPanel();
                        regionJPanel.addMouseListener(new RegionMouseListener(word, j, region));
                        imagePanel.add(regionJPanel);
                    }
                    catch (NoWayToShowException e) {
                        e.printStackTrace();
                    }
                }
                gbc.gridx = j + 1;
                gbc.gridy = i;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                layout.setConstraints(labelPanel, gbc);
                gbc.gridx = j + 1;
                gbc.gridy = i + 1;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                layout.setConstraints(imagePanel, gbc);
                panelBase.add(labelPanel);
                panelBase.add(imagePanel);
            }
            i += 2;
        }
        return panelBase;
    }

    public void research(boolean scroll) {
        if (this.scrollpane != null) {
            this.scrollpane.remove(this.tablePanel);
        }
        this.tablePanel.removeAll();
        this.tablePanel = this.getTable(this.presentPage, this.searchField.getText());
        this.setResultPanel(this.tablePanel, scroll);
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public String getCchoiceWord() {
        return this.choiceword;
    }

    public void search(String text, boolean isRegularExpressions, boolean isCaseSensitive) {
        this.searchField.setText(text);
        this.regularExpressionsBox.setSelected(isRegularExpressions);
        this.caseSensitiveBox.setSelected(isCaseSensitive);
        this.presentPage = 0;
        this.research(false);
    }

    JMenuBar setMenu() {
        JMenuBar mnbar = new JMenuBar();
        JMenu mnFile = new JMenu("\u30d5\u30a1\u30a4\u30eb");
        JMenu mnOption = new JMenu("\u30aa\u30d7\u30b7\u30e7\u30f3");
        JMenu mnHelp = new JMenu("\u30d8\u30eb\u30d7");
        mnbar.add(mnFile);
        JMenuItem mniOpen = new JMenuItem("\u958b\u304f");
        JMenuItem mniExit = new JMenuItem("\u7d42\u4e86");
        mnFile.add(mniOpen);
        mnFile.addSeparator();
        mnFile.add(mniExit);
        mnbar.add(mnOption);
        mnbar.add(mnHelp);
        mnbar.setToolTipText("\u3053\u308c\u306f\u3001\u30e1\u30cb\u30e5\u30fc\u30d0\u30fc\u3067\u3059");
        mnFile.setToolTipText("\u3053\u308c\u306f\u3001\u30d5\u30a1\u30a4\u30eb  \u3067\u3059");
        mnOption.setToolTipText("\u3053\u308c\u306f\u3001\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u3059");
        mnHelp.setToolTipText("\u3053\u308c\u306f\u3001\u30d8\u30eb\u30d7    \u3067\u3059");
        mniOpen.setToolTipText("\u3053\u308c\u306f\u3001\u958b\u304f      \u3067\u3059");
        mniExit.setToolTipText("\u3053\u308c\u306f\u3001\u7d42\u4e86      \u3067\u3059");
        return mnbar;
    }

    class ColorLabel
    extends JLabel {
        ColorLabel() {
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DictionaryXML dictionaryXML = DictionaryXML.getInstance();
            dictionaryXML.deleteRegion(DictionaryDialog.this.choiceword, DictionaryDialog.this.choiceindex);
            try {
                dictionaryXML.write();
                dictionaryXML.load();
                TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
                if (dictionaryMap.size() != 0 && dictionaryMap.size() % 5 == 0) {
                    DictionaryDialog.this.presentPage -= 5;
                }
                DictionaryDialog.this.research(true);
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
        }
    }

    class SelectWordAction
    implements ActionListener {
        protected String word;

        public SelectWordAction(String word) {
            this.word = word;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DictionaryDialog.this.choiceword = this.word;
            DictionaryDialog.this.myDialog.setVisible(false);
        }
    }

    class LeftMovedAction
    implements ActionListener {
        LeftMovedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DictionaryXML dictionaryXML = DictionaryXML.getInstance();
            TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
            Dictionary dictionary = dictionaryMap.get(DictionaryDialog.this.choiceword);
            ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
            DictionaryRegion dictionaryRegion = regionList.remove(DictionaryDialog.this.choiceindex);
            regionList.add(DictionaryDialog.this.choiceindex - 1, dictionaryRegion);
            try {
                dictionaryXML.write();
                dictionaryXML.load();
                DictionaryDialog.this.research(true);
                for (int i = 0; i < DictionaryDialog.this.textList.size(); ++i) {
                    JTextField textField = DictionaryDialog.this.textList.get(i);
                    if (!textField.getText().equals(DictionaryDialog.this.choiceword)) continue;
                    textField.requestFocus();
                    break;
                }
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
        }
    }

    class RightMovedAction
    implements ActionListener {
        RightMovedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DictionaryXML dictionaryXML = DictionaryXML.getInstance();
            TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
            Dictionary dictionary = dictionaryMap.get(DictionaryDialog.this.choiceword);
            ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
            DictionaryRegion dictionaryRegion = regionList.remove(DictionaryDialog.this.choiceindex);
            regionList.add(DictionaryDialog.this.choiceindex + 1, dictionaryRegion);
            try {
                dictionaryXML.write();
                dictionaryXML.load();
                DictionaryDialog.this.research(true);
                for (int i = 0; i < DictionaryDialog.this.textList.size(); ++i) {
                    JTextField textField = DictionaryDialog.this.textList.get(i);
                    if (!textField.getText().equals(DictionaryDialog.this.choiceword)) continue;
                    textField.requestFocus();
                    break;
                }
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
        }
    }

    class TextFieldFocusListener
    implements FocusListener {
        protected JTextField textField;
        protected String temp;

        public TextFieldFocusListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.temp = this.textField.getText();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DictionaryXML dictionaryXML;
            Dictionary dictionary;
            String temp_ = this.textField.getText();
            if (!temp_.equals(this.temp) && (dictionary = (dictionaryXML = DictionaryXML.getInstance()).getDictionary(this.temp)) != null) {
                dictionaryXML.delete(this.temp);
                dictionary.setWord(temp_);
                dictionaryXML.add(temp_, dictionary);
                try {
                    dictionaryXML.write();
                    dictionaryXML.load();
                    DictionaryDialog.this.research(false);
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    class DictonaryTextDeleteListener
    implements ActionListener {
        protected String word;

        public DictonaryTextDeleteListener(String word) {
            this.word = word;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int value = JOptionPane.showConfirmDialog(WorkspaceWindow.getInstance(), "Do you delete word ?", "Confirmation", 0);
            if (value != 0) {
                return;
            }
            DictionaryXML dictionaryXML = DictionaryXML.getInstance();
            dictionaryXML.delete(this.word);
            try {
                dictionaryXML.write();
                dictionaryXML.load();
                TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
                if (dictionaryMap.size() != 0 && dictionaryMap.size() % 5 == 0) {
                    DictionaryDialog.this.presentPage -= 5;
                }
                DictionaryDialog.this.research(true);
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
            WorkspaceWindow.setUpdated(true);
        }
    }

    class RegionMouseListener
    implements MouseListener {
        private GS_RWElement element;
        private String word;
        private int index;

        public RegionMouseListener(String word, int index, GS_RWElement element) {
            this.element = element;
            this.word = word;
            this.index = index;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                DictionaryDialog.this.choiceindex = this.index;
                DictionaryDialog.this.choiceword = this.word;
                DictionaryXML dictionaryXML = DictionaryXML.getInstance();
                TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
                Dictionary dictionary = dictionaryMap.get(this.word);
                ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
                if (this.index == 0) {
                    DictionaryDialog.this.leftProperty.setVisible(false);
                } else {
                    DictionaryDialog.this.leftProperty.setVisible(true);
                }
                if (regionList.size() > this.index + 1) {
                    DictionaryDialog.this.rightProperty.setVisible(true);
                } else {
                    DictionaryDialog.this.rightProperty.setVisible(false);
                }
                DictionaryDialog.this.popup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                this.element.show();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class WindowClosing
    extends WindowAdapter {
        WindowClosing() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DictionaryDialog.this.myDialog.setVisible(false);
            DictionaryDialog.this.cancel = true;
        }
    }
}

