/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.action;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.SimpleInfoDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JColorChooser;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;

public class CreateCustomTag {
    protected GSHTMLEditor parentEkit;
    private HTML.Tag htmlTag;
    private Hashtable htmlAttribs;

    public CreateCustomTag(GSHTMLEditor ekit, String actionName, HTML.Tag inTag, Hashtable attribs) {
        this.parentEkit = ekit;
        this.htmlTag = inTag;
        this.htmlAttribs = attribs;
    }

    public CreateCustomTag(GSHTMLEditor ekit, String actionName, HTML.Tag inTag) {
        this(ekit, actionName, inTag, new Hashtable());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent ae) {
        Object entryValue;
        Object entryKey;
        Hashtable<String, String> htmlAttribs2 = new Hashtable<String, String>();
        JTextPane parentTextPane = this.parentEkit.getTextPane();
        String selText = parentTextPane.getSelectedText();
        int textLength = -1;
        if (selText != null) {
            textLength = selText.length();
        }
        if (selText == null || textLength < 1) {
            SimpleInfoDialog sidWarn = new SimpleInfoDialog(this.parentEkit.getFrame(), "Error*", true, "No text was selected.*", 0);
            return;
        }
        int caretOffset = parentTextPane.getSelectionStart();
        int internalTextLength = selText.length();
        String currentAnchor = "";
        if (this.htmlTag.toString().equals(HTML.Tag.A.toString())) {
            SimpleAttributeSet sasText = null;
            for (int i = caretOffset; i < caretOffset + internalTextLength; ++i) {
                parentTextPane.select(i, i + 1);
                sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
                Enumeration<?> attribEntries1 = sasText.getAttributeNames();
                block1: while (attribEntries1.hasMoreElements() && currentAnchor.equals("")) {
                    entryKey = attribEntries1.nextElement();
                    entryValue = sasText.getAttribute(entryKey);
                    if (!entryKey.toString().equals(HTML.Tag.A.toString()) || !(entryValue instanceof SimpleAttributeSet)) continue;
                    Enumeration<?> subAttributes = ((SimpleAttributeSet)entryValue).getAttributeNames();
                    while (subAttributes.hasMoreElements() && currentAnchor.equals("")) {
                        Object subKey = subAttributes.nextElement();
                        if (!subKey.toString().toLowerCase().equals("href")) continue;
                        currentAnchor = ((SimpleAttributeSet)entryValue).getAttribute(subKey).toString();
                        continue block1;
                    }
                }
                if (!currentAnchor.equals("")) break;
            }
        }
        parentTextPane.select(caretOffset, caretOffset + internalTextLength);
        SimpleAttributeSet sasTag = new SimpleAttributeSet();
        SimpleAttributeSet sasAttr = new SimpleAttributeSet();
        if (this.htmlTag.toString().equals(HTML.Tag.A.toString())) {
            if (!this.htmlAttribs.containsKey("href")) {
                String newAnchor = this.createHyperlink();
                String id = this.createHyperlinkID();
                if (newAnchor == null) {
                    this.parentEkit.repaint();
                    return;
                }
                htmlAttribs2.put("href", id);
                htmlAttribs2.put("id", newAnchor);
            }
        } else if (this.htmlTag.toString().equals(HTML.Tag.FONT.toString()) && this.htmlAttribs.containsKey("color")) {
            new JColorChooser();
            Color color = JColorChooser.showDialog(this.parentEkit.getFrame(), "Choose Text Color*", Color.black);
            if (color != null) {
                StyledEditorKit.ForegroundAction customColorAction = new StyledEditorKit.ForegroundAction("CustomColor", color);
                customColorAction.actionPerformed(ae);
            }
        }
        if (htmlAttribs2.size() > 0) {
            Enumeration attribEntries = htmlAttribs2.keys();
            while (attribEntries.hasMoreElements()) {
                entryKey = attribEntries.nextElement();
                entryValue = htmlAttribs2.get(entryKey);
                this.insertAttribute(sasAttr, entryKey, entryValue);
            }
            SimpleAttributeSet baseAttrs = new SimpleAttributeSet(this.parentEkit.getTextPane().getCharacterAttributes());
            Enumeration<?> attribEntriesOriginal = baseAttrs.getAttributeNames();
            while (attribEntriesOriginal.hasMoreElements()) {
                Object entryKey2 = attribEntriesOriginal.nextElement();
                Object entryValue2 = baseAttrs.getAttribute(entryKey2);
                this.insertAttribute(sasAttr, entryKey2, entryValue2);
            }
            sasTag.addAttribute(this.htmlTag, sasAttr);
            parentTextPane.setCharacterAttributes(sasTag, false);
            this.parentEkit.refreshOnUpdate();
        }
        parentTextPane.select(caretOffset, caretOffset + internalTextLength);
        parentTextPane.requestFocus();
    }

    public String createHyperlink() {
        return null;
    }

    public String createHyperlinkID() {
        return null;
    }

    private void insertAttribute(SimpleAttributeSet attrs, Object key, Object value) {
        if (value instanceof AttributeSet) {
            AttributeSet subSet = (AttributeSet)value;
            Enumeration<?> attribEntriesSub = subSet.getAttributeNames();
            while (attribEntriesSub.hasMoreElements()) {
                Object subKey = attribEntriesSub.nextElement();
                Object subValue = subSet.getAttribute(subKey);
                this.insertAttr(attrs, subKey, subValue);
            }
        } else {
            this.insertAttr(attrs, key, value);
        }
        if (key.toString().toLowerCase().equals("font-family")) {
            if (attrs.isDefined("face")) {
                this.insertAttr(attrs, "face", attrs.getAttribute("face"));
                this.insertAttr(attrs, "font-family", attrs.getAttribute("face"));
            } else {
                this.insertAttr(attrs, "face", value);
            }
        }
    }

    private void insertAttr(SimpleAttributeSet attrs, Object key, Object value) {
        while (attrs.isDefined(key)) {
            attrs.removeAttribute(key);
        }
        attrs.addAttribute(key, value);
    }
}

