package hayashi.kiban;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.areaweb.tools.database.*;

public class DbBuscourse {
	/** メイン
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException, SQLException
	{
		Connection con = null;
		try {
			con = DatabaseTool.openDb("database");
			DbBuscourse.export(con);
		}
		finally {
			if (con != null) {
				DatabaseTool.closeDb(con);
			}
		}
	}

	/**
	 * 'table.bus_course'を新規に作る
	 *
	 * TABLE "bus_course"	(
	 * 		code int,
	 * 		type int,
	 * 		corp VARCHAR(128) NOT NULL,
	 * 		course VARCHAR(512),
	 * 		ifile VARCHAR(128),
	 * 		CONSTRAINT bus_course_pk PRIMARY KEY(code))
	 *
	 * @param con
	 * @throws SQLException
	 */
	public static void create(Connection con) throws SQLException {
		String createSt = "CREATE TABLE bus_course (code int, type int, corp VARCHAR(128) NOT NULL, course VARCHAR(512), ifile VARCHAR(128), CONSTRAINT bus_course_pk PRIMARY KEY(code));";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * 'table.bus_course'を削除する
	 * @param con
	 * @throws SQLException
	 */
	public static void drop(Connection con) throws SQLException {
		String createSt = "DROP TABLE bus_course;";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * テーブルの初期化
	 * @param con
	 */
	public static void initDb(Connection con) {
		// 'table.bus_course'を削除する
		try {
			DbBuscourse.drop(con);
		}
		catch (SQLException e) {
			System.out.println("table [bus_course] is not created.");
		}

		// 'table.bus_course'を新規に作る
		try {
			DbBuscourse.create(con);
		}
		catch (SQLException e) {
			System.out.println("table [bus_course] is already created.");
		}
	}

	/**
	 * 'table.bus_course'の内容をCSV形式にして標準出力に出力する
	 * @param con
	 */
	public static void export(Connection con) {
		try {
			System.out.println("TABLE: bus_course");
			System.out.println("\"code\",\"type\",\"corp\",\"course\",\"ifile\"");
			PreparedStatement ps8 = con.prepareStatement("SELECT code,type,corp,course,ifile FROM bus_course");
			ResultSet rset8 = ps8.executeQuery();
			while (rset8.next()) {
				int code = rset8.getInt("code");
				int type = rset8.getInt("type");
				String corp = rset8.getString("corp");
				String course = rset8.getString("course");
				String ifile = rset8.getString("ifile");
				System.out.println(code +","+ type +",\""+ corp +"\",\""+ course +"\",\""+ ifile +"\"");
			}
			rset8.close();
		}
		catch (SQLException e) {
			e.printStackTrace();
		}
	}
}