package com.jm.utility;

import com.jm.JugglerCanvas;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;

public class Graphics {
	private int center;
	private Canvas canvas;
	private Paint paint = new Paint();
	private static Graphics instance = new Graphics();
	
	private Graphics(){
		
	}
	
	public static Graphics getInstance(){
		return instance;
	}
	
	public void setCanvas(Canvas canvas) {
		this.canvas = canvas;
	}

	public void translate(int center, int i) {
		this.center = center;
	}

	public void fillRect(int x, int y, int width, int height) {
        if (canvas != null){
        	paint.setColor(Color.WHITE);
    		paint.setStyle(Paint.Style.FILL);
        	canvas.drawRect(x + center, y, x + center + width, y + height, paint);
        }
	}

	public void drawString(String str, int x, int y, int anchor, int color) {
        if (canvas != null){
        	paint.setColor(color);
        	canvas.drawText(str, x + center, y, paint);
        }
	}

	public void drawLine(int x1, int y1, int x2, int y2) {
        if (canvas != null){
        	paint.setColor(Color.BLACK);
        	canvas.drawLine(x1 + center, y1, x2 + center, y2, paint);
        }
	}

	public void drawCircle(int x, int y, int r) {
        if (canvas != null){
        	paint.setColor(Color.BLACK);
    		paint.setStyle(Paint.Style.STROKE);
        	canvas.drawCircle(x + center, y, r, paint);
        }
	}

	public void drawImage(int i, int x, int y, int size) {
        if (canvas != null){
        	int color = JugglerCanvas.color[i % JugglerCanvas.color.length];
        	paint.setColor(color | 0xff000000);
    		paint.setStyle(Paint.Style.FILL);
        	canvas.drawCircle(x + center, y, size, paint);
        }
	}

}
