package com.yuji.ef;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff.Mode;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yuji.ef.dao.Node;

public class LabelIconView extends LinearLayout {
	private int initX = 0;
	private int initY = 0;

	private LabelIconView statusImageView = null;
	private ImageView imageView = null;
	private TextView textView = null;
	private long id;

	public LabelIconView(Context context) {
		super(context);
	}

	public long getNodeId() {
		return id;
	}

	public void init(int x, int y, Bitmap bmp1, Bitmap bmp2, String text) {
		init(x, y);
		Context context = this.getContext();

		if (imageView != null) {
			this.removeView(imageView);
		}
		if (textView != null) {
			this.removeView(textView);
		}

		// TODO
		if (bmp1 != null) {
			statusImageView = new StatusIconView(context, this);
			//statusImageView.setImageBitmap(bmp1);
		}

		imageView = new ImageView(context);
		imageView.setImageBitmap(bmp2);

		if (text != null) {
			textView = new TextView(context);
			textView.setText(text);
		}
		addView(imageView);
		if (textView != null) {
			addView(textView);
		}
	}

	public void setNodeId(long id) {
		this.id = id;
		if (statusImageView != null){
			statusImageView.setNodeId(id);
		}
	}

	public int getInitX() {
		return initX;
	}

	public int getInitY() {
		return initY;
	}

	public LabelIconView getStatusImageView() {
		return statusImageView;
	}

	public void init(int x, int y) {
		initX = x;
		initY = y;
	}

	public void setAlpha(int alpha) {
		imageView.setAlpha(alpha);
	}

	public void setColorFilter(int color, Mode mode) {
		imageView.setColorFilter(color, mode);
	}

	public void clearColorFilter() {
		imageView.clearColorFilter();
	}
}
