/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.edam.util;

import com.evernote.edam.error.EDAMErrorCode;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.type.Data;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.UserStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class EDAMUtil {
    public static final Charset UTF8;
    public static final Charset DEFAULT_CHARSET;
    private static final ConcurrentHashMap<String, Charset> encodingToCharsetCache;
    public static final String EDAM_HASH_ALGORITHM = "MD5";
    private static final char[] HEX_DIGITS;

    static {
        DEFAULT_CHARSET = UTF8 = Charset.forName("UTF-8");
        encodingToCharsetCache = new ConcurrentHashMap();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public static final String getUserAgentString(String applicationName, String svnRevisionNumber) {
        return String.valueOf(applicationName) + "/" + svnRevisionNumber + ";" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "; Java " + System.getProperty("java.vendor") + "/" + System.getProperty("java.version") + ";";
    }

    public static UserStore.Client getUserStoreClient(String host, String userAgent) throws TTransportException {
        return EDAMUtil.getUserStoreClient(host, userAgent, null);
    }

    public static UserStore.Client getUserStoreClient(String host, String userAgent, Map<String, String> customHeaders) throws TTransportException {
        String url = host.contains(":") ? "http://" : "https://";
        url = String.valueOf(url) + host + "/edam/user";
        THttpClient transport = new THttpClient(url);
        if (customHeaders != null) {
            for (Map.Entry<String, String> header : customHeaders.entrySet()) {
                transport.setCustomHeader(header.getKey(), header.getValue());
            }
        }
        if (userAgent != null) {
            transport.setCustomHeader("User-Agent", userAgent);
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport){

            public void readMessageEnd() {
                ((THttpClient)this.getTransport()).close();
            }
        };
        return new UserStore.Client((TProtocol)protocol, (TProtocol)protocol);
    }

    public static NoteStore.Client getNoteStoreClient(String url, String userAgent) throws TTransportException {
        return EDAMUtil.getNoteStoreClient(url, userAgent, null);
    }

    public static NoteStore.Client getNoteStoreClient(AuthenticationResult authResult, String userAgent) throws TTransportException {
        return EDAMUtil.getNoteStoreClient(authResult.getNoteStoreUrl(), userAgent, null);
    }

    public static NoteStore.Client getNoteStoreClient(String url, String userAgent, Map<String, String> customHeaders) throws TTransportException {
        THttpClient transport = new THttpClient(url);
        if (customHeaders != null) {
            for (Map.Entry<String, String> header : customHeaders.entrySet()) {
                transport.setCustomHeader(header.getKey(), header.getValue());
            }
        }
        if (userAgent != null) {
            transport.setCustomHeader("User-Agent", userAgent);
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport){

            public void readMessageEnd() {
                ((THttpClient)this.getTransport()).close();
            }
        };
        return new NoteStore.Client((TProtocol)protocol, (TProtocol)protocol);
    }

    public static String bytesToHex(byte[] bytes) {
        return EDAMUtil.bytesToHex(bytes, false);
    }

    public static String bytesToHex(byte[] bytes, boolean withSpaces) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte hashByte = byArray[n2];
            int intVal = 0xFF & hashByte;
            if (intVal < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(intVal));
            if (withSpaces) {
                sb.append(' ');
            }
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hexString) {
        byte[] result = new byte[hexString.length() / 2];
        int i = 0;
        while (i < result.length) {
            int offset = i * 2;
            result[i] = (byte)Integer.parseInt(hexString.substring(offset, offset + 2), 16);
            ++i;
        }
        return result;
    }

    public static byte[] stringToBytes(String string) {
        return EDAMUtil.stringToBytes(string, DEFAULT_CHARSET);
    }

    public static byte[] stringToBytes(String string, String encoding) {
        return EDAMUtil.stringToBytes(string, EDAMUtil.getCharset(encoding));
    }

    private static byte[] stringToBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        ByteBuffer encoded = charset.encode(string);
        byte[] result = new byte[encoded.remaining()];
        encoded.get(result, 0, result.length);
        return result;
    }

    public static byte[] charBufferToBytes(CharBuffer buffer) {
        return EDAMUtil.charBufferToBytes(buffer, DEFAULT_CHARSET);
    }

    private static byte[] charBufferToBytes(CharBuffer buffer, Charset charset) {
        if (buffer == null) {
            return null;
        }
        ByteBuffer encoded = charset.encode(buffer);
        byte[] result = new byte[encoded.remaining()];
        encoded.get(result, 0, result.length);
        return result;
    }

    public static String bytesToString(byte[] bytes) {
        return EDAMUtil.bytesToString(bytes, DEFAULT_CHARSET);
    }

    public static String bytesToString(byte[] bytes, String encoding) {
        return EDAMUtil.bytesToString(bytes, EDAMUtil.getCharset(encoding));
    }

    private static String bytesToString(byte[] bytes, Charset charSet) {
        if (bytes == null) {
            return null;
        }
        return charSet.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static Data bytesToData(byte[] body) {
        return EDAMUtil.bytesToData(body, true);
    }

    public static Data bytesToData(byte[] body, boolean includeBody) {
        Data data = new Data();
        data.setSize(body.length);
        data.setBodyHash(EDAMUtil.hash(body));
        if (includeBody) {
            data.setBody(body);
        }
        return data;
    }

    public static byte[] hash(byte[] body) {
        try {
            return MessageDigest.getInstance(EDAM_HASH_ALGORITHM).digest(body);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EDAMUtilException("MD5 not supported", e);
        }
    }

    public static byte[] hash(InputStream in) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(EDAM_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EDAMUtilException("MD5 not supported", e);
        }
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) != -1) {
            digest.update(buf, 0, n);
        }
        return digest.digest();
    }

    public static byte[] hash(String content) {
        return EDAMUtil.hash(EDAMUtil.stringToBytes(content));
    }

    public static String dataToString(Data d) {
        return EDAMUtil.dataToString(d, DEFAULT_CHARSET);
    }

    public static String dataToString(Data d, String encoding) {
        return EDAMUtil.dataToString(d, EDAMUtil.getCharset(encoding));
    }

    private static String dataToString(Data d, Charset charSet) {
        byte[] dataBytes = d.getBody();
        if (d.getBody() == null) {
            return null;
        }
        return EDAMUtil.bytesToString(dataBytes, charSet);
    }

    public static Data stringToData(String body, boolean includeBody) {
        return EDAMUtil.bytesToData(EDAMUtil.stringToBytes(body), includeBody);
    }

    public static Data stringToData(String body, Charset charSet, boolean includeBody) throws UnsupportedEncodingException {
        return EDAMUtil.bytesToData(EDAMUtil.stringToBytes(body, charSet), includeBody);
    }

    public static Data stringToData(String body, String charSet, boolean includeBody) throws UnsupportedEncodingException {
        return EDAMUtil.bytesToData(EDAMUtil.stringToBytes(body, charSet), includeBody);
    }

    private EDAMUtil() {
    }

    public static EDAMUserException newUserException(EDAMErrorCode errorCode, String param) {
        EDAMUserException ex = new EDAMUserException(errorCode);
        if (param != null) {
            ex.setParameter(param);
        }
        return ex;
    }

    public static EDAMSystemException newSystemException(EDAMErrorCode errorCode, String message) {
        EDAMSystemException ex = new EDAMSystemException(errorCode);
        if (message != null) {
            ex.setMessage(message);
        }
        return ex;
    }

    public static EDAMNotFoundException newNotFoundException(String identifier, String key) {
        EDAMNotFoundException ex = new EDAMNotFoundException();
        ex.setIdentifier(identifier);
        ex.setKey(key);
        return ex;
    }

    public static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = EDAMUtil.stringToBytes(s);
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            if (b >= 65 && b <= 90 || b >= 97 && b <= 122 || b >= 48 && b <= 57 || b == 46 || b == 45 || b == 95) {
                sb.append((char)b);
            } else {
                sb.append('%');
                sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                sb.append(HEX_DIGITS[b & 0xF]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static Charset getCharset(String enc) {
        Charset charset = encodingToCharsetCache.get(enc);
        if (charset == null) {
            charset = Charset.forName(enc);
            encodingToCharsetCache.put(enc, charset);
        }
        return charset;
    }

    private static final class EDAMUtilException
    extends RuntimeException {
        private static final long serialVersionUID = -8099786694856724498L;

        public EDAMUtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

