package com.yuji.ef.utility;

import java.util.HashMap;
import java.util.List;

import android.database.sqlite.SQLiteDatabase;

import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.yuji.ef.common.CommonUtil;
import com.yuji.ef.dao.Book;
import com.yuji.ef.dao.BookDao;
import com.yuji.ef.dao.DatabaseHelper;
import com.yuji.ef.dao.DirNode;
import com.yuji.ef.dao.FileNode;
import com.yuji.ef.dao.Node;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.dao.RootNode;

public class FolderUtil {
	private EvernoteUtil util = EvernoteUtil.getInstance();
	private NodeDao nodeDao = (NodeDao) NodeDao.getInstance();
	private BookDao bookDao = (BookDao) BookDao.getInstance();

	public static FolderUtil getInstance() {
		if (instance == null) {
			instance = new FolderUtil();
		}
		return instance;
	}

	private static FolderUtil instance = null;

	private FolderUtil() {

	}

	public void init(SQLiteDatabase db) {
		// List<Notebook> noteBookList = util.getNoteBookList();
		// List<Tag> tagList = util.getTagList();

		// nodeDao.delete(db);

		// ROOT
//		Node node;
//		Node n;
//		String guid;
		long id;

		Node top = new RootNode("", null);
		id = nodeDao.addNT(top);
		top.setId(id);

		updateNotebook(db);

		// TODO
		updateNote(db);
//		List<Book> noteBookList = bookDao.search(db);
//		HashMap<String, Node> map = new HashMap<String, Node>();
//		for (Book noteBook : noteBookList) {
//			guid = noteBook.getGuid();
//			DirNode dirNode = (DirNode) nodeDao.searchById(db,
//					noteBook.getNId());
//			if (dirNode == null) {
//				// TODO
//			}
//			map.put(guid, dirNode);
//		}
//
//		List<NoteList> noteListList = util.getNoteList();
//		for (NoteList noteList : noteListList) {
//			List<Note> notes = noteList.getNotes();
//			for (Note note : notes) {
//				String name = note.getTitle();
//				guid = note.getNotebookGuid();
//
//				node = map.get(guid);
//				if (node != null) {
//					n = new FileNode(name, null);
//					n.setGuid(note.getGuid());
//					addFileNodeNT(node, n);
//				}
//			}
//		}
	}

	public void updateNotebook(SQLiteDatabase db) {
		List<Notebook> noteBookList = util.getNoteBookList();

		long id;
		Node top = nodeDao.searchRoot(db);

		for (Notebook notebook : noteBookList) {
			String guid = notebook.getGuid();
			String name = notebook.getName();

			Book oldBook = bookDao.searchByGuid(db, guid);
			if (oldBook == null) {
				DirNode dirNode = new DirNode(name, null);
				guid = notebook.getGuid();
				dirNode.setGuid(guid);

				id = addDirNodeNT(top, dirNode);

				Book book = new Book(-1, guid, id, name);
				bookDao.addNT(book);
			} else {
				String oldName = oldBook.getName();
				if (!name.equals(oldName)) {
					// 名称が異なる
					bookDao.updateNameNT(oldBook, name);

					Node node = nodeDao.searchById(db, oldBook.getNId());
					nodeDao.updateNameNT(node, name);
				}
			}
		}
	}

	public void updateNote(SQLiteDatabase db) {
		List<NoteList> noteListList = util.getNoteList();
		for (NoteList noteList : noteListList) {
			List<Note> notes = noteList.getNotes();
			for (Note note : notes) {
				String name = note.getTitle();
				String guid = note.getGuid();
				String nbGuid = note.getNotebookGuid();

				Node oldNote = nodeDao.searchByGuid(db, guid);
				if (oldNote == null) {
					// 新規ノート
					DirNode parent = (DirNode)nodeDao.searchByGuid(db, nbGuid);
					if (parent == null) {
						// TODO
					}

					FileNode fileNode = new FileNode(name, null);
					fileNode.setGuid(guid);

					long id = addFileNodeNT(parent, fileNode);
					fileNode.setId(id);
					nodeDao.addNT(fileNode);
				} else {
					DirNode oldParent = (DirNode)nodeDao.searchById(db,
							oldNote.getParent());
					if (oldParent == null) {
						// TODO
					}

					String oldName = oldNote.getName();
					if (!name.equals(oldName)) {
						// 名称が異なる
						nodeDao.updateNameNT(oldNote, name);
					}

					String pGuid = oldParent.getGuid();
					if (!CommonUtil.isNull(pGuid) && !pGuid.equals(nbGuid)) {
						// 親が異なる
						DirNode parent = (DirNode)nodeDao.searchByGuid(db, nbGuid);
						if (parent == null) {
							// TODO
						}

						long id;
						id = nodeDao.remoteChildrenIdNT(oldParent, oldNote.getId());
						if (id < 0){
							// TODO
						}
						id = nodeDao.addChildrenIdNT(parent, oldNote.getId());
						if (id < 0){
							// TODO
						}
						nodeDao.updateParentNT(oldNote, parent.getId());
					}
				}
			}
		}
	}

	public long addFileNode(Node parent, Node node) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return addFileNode(db, parent, node);
	}

	public long addFileNode(SQLiteDatabase db, Node parent, Node node) {
		long id = -1;

		db.beginTransaction();
		try {
			id = addFileNodeNT(parent, node);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	private long addFileNodeNT(Node parent, Node node) {
		long id;
		node.setParent(parent.getId());
		id = nodeDao.addNT(node);
		nodeDao.addChildrenIdNT(parent, id);
		return id;
	}

	public long addDirNode(Node parent, Node node) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return addDirNode(db, parent, node);
	}

	public long addDirNode(SQLiteDatabase db, Node parent, Node node) {
		long id = -1;

		db.beginTransaction();
		try {
			id = addDirNodeNT(parent, node);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	private long addDirNodeNT(Node parent, Node node) {
		long id;
		node.setParent(parent.getId());
		id = nodeDao.addNT(node);
		node.setId(id);
		nodeDao.addChildrenIdNT(parent, node.getId());
		return id;
	}

	public long deleteNode(Node node) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return deleteNode(db, node);
	}

	public long deleteNode(SQLiteDatabase db, Node node) {
		long id = -1;

		db.beginTransaction();
		try {
			id = deleteNodeNT(node);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	private long deleteNodeNT(Node node) {
		long id;

		if (node instanceof DirNode) {
			DirNode dirNode = (DirNode) node;
			List<Long> list = dirNode.getChildren();
			for (Long l : list) {
				id = l.longValue();
				Node n = nodeDao.searchById(id);
				if (n != null) {
					deleteNodeNT(n);
				}
			}
		}

		id = node.getParent();
		if (id >= 0) {
			Node p = nodeDao.searchById(id);
			if (p != null) {
				nodeDao.remoteChildrenIdNT(p, node.getId());
			}
		}
		nodeDao.deleteNT(node.getId());

		return 0;
	}
}
