package com.yuji.ef;

import java.util.List;

import android.content.Intent;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.widget.Button;

import com.yuji.ef.dao.DatabaseHelper;
import com.yuji.ef.dao.DirNode;
import com.yuji.ef.dao.FileNode;
import com.yuji.ef.dao.IDao;
import com.yuji.ef.dao.Node;
import com.yuji.ef.dao.Node.Status;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.dao.RootNode;
import com.yuji.ef.utility.BaseActivity;
import com.yuji.ef.utility.EvernoteIntentUtil;
import com.yuji.ef.utility.FolderUtil;

public class EverFolderActivity extends BaseActivity {
	private IconFrameLayout layout;
	private IconScrollView scrollView;
	private Button leftButton;
	private Button rightButton;
	private Button addButton;
	private Button deleteButton;

	private Node top = null;
	private int indent = 0;
	private int viewY;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		try {
			scrollView = (IconScrollView) findViewById(R.id.scrollView);
			layout = (IconFrameLayout) findViewById(R.id.frameLayout);
			layout.setActivity(this);
			layout.setScrollView(scrollView);

			leftButton = (Button) findViewById(R.id.leftButton);
			rightButton = (Button) findViewById(R.id.rightButton);
			addButton = (Button) findViewById(R.id.addButton);
			deleteButton = (Button) findViewById(R.id.deleteButton);

			leftButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					leftButtonOnClick();
				}
			});
			rightButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					rightButtonOnClick();
				}
			});
			addButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					addButtonOnClick();
				}
			});
			deleteButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					deleteButtonOnClick();
				}
			});

			updateList();
			setStatus();
		} catch (Exception e) {
			// TODO
			e.printStackTrace();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		boolean ret = super.onCreateOptionsMenu(menu);
		menu.add(Menu.NONE, Menu.FIRST, Menu.NONE, "XXX");
		menu.add(Menu.NONE, Menu.FIRST + 1, Menu.NONE, "設定");
		return ret;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		Intent intent;
		try {
			switch (item.getItemId()) {
			case Menu.FIRST:
				dummy();
				break;
			case Menu.FIRST + 1:
				intent = new Intent(this, (Class<?>) SettingActivity.class);
				startActivityForResult(intent, 0);
				break;
			default:
				break;
			}
		} catch (Exception e) {
			terminate(e);
		}
		return super.onOptionsItemSelected(item);
	}

	private void dummy(){
		try {
			FolderUtil util = FolderUtil.getInstance();
			
			DatabaseHelper helper = DatabaseHelper.getInstance();
			SQLiteDatabase db = helper.getWritableDatabase();
			
			db.beginTransaction();
			try {
				util.updateNotebook(db);
				util.updateNote(db);
				
				db.setTransactionSuccessful();
			} finally {
				db.endTransaction();
			}			
			updateList();
			setStatus();
		}
		catch (Exception e){
			// TODO
			e.printStackTrace();
		}
	}
	
	private void updateList() {
		NodeDao dao = (NodeDao) NodeDao.getInstance();
		top = dao.searchRoot();
		if (top == null) {
			// TODO
		}
		layout.removeAllViews();
		updateList(top);
	}

	private void updateList(Node parent) {
		viewY = 30;

		// List<Node> list = parent.getChildren();
		// for (Node node : list){
		// updateList(node, x);
		// }
		updateList(parent, 0);
		layout.setMinimumHeight(viewY);
		layout.invalidate();
	}

	private void updateList(Node node, int depth) {
		int N = 100;
		int M = 120;
		int x = N * (depth - indent) + 50;

		if (depth - indent >= 0
				&& !(depth - indent == 0 && node instanceof FileNode)) {
			LabelIconView view = new LabelIconView(this);
			node.setView(view);

			Resources r = getResources();
			Bitmap bmp1 = null;
			int id = node.getStatusIconId();
			if (id >= 0) {
				bmp1 = BitmapFactory.decodeResource(r, node.getStatusIconId());
			}
			Bitmap bmp2 = BitmapFactory.decodeResource(r, node.getIconId());
			createIconImageView(view, bmp1, bmp2, node.getName(), x, viewY);
			LabelIconView s = view.getStatusImageView();
			if (s != null) {
				s.setNodeId(node.getId());
			}
		}
		viewY += M;

		if (node.getStatus() != Node.Status.OPEN) {
			return;
		}
		List<Long> list = node.getChildren();
		if (list == null) {
			return;
		}

		NodeDao dao = (NodeDao) NodeDao.getInstance();
		for (Long id : list) {
			Node n = dao.searchById(id);
			updateList(n, depth + 1);
		}
	}

	private void createIconImageView(LabelIconView v, Bitmap bmp1, Bitmap bmp2,
			String text, int x, int y) {
		v.init(x, y, bmp1, bmp2, text);

		android.view.WindowManager.LayoutParams params = new WindowManager.LayoutParams();
		params.gravity = Gravity.TOP | Gravity.LEFT;
		params.height = WindowManager.LayoutParams.WRAP_CONTENT;
		params.width = WindowManager.LayoutParams.WRAP_CONTENT;
		params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
				| WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE
				| WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON
				| WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
		params.format = PixelFormat.TRANSLUCENT;
		params.windowAnimations = 0;
		params.x = x;
		params.y = y;
		v.setLayoutParams(params);

		layout.addView(v);
		v.layout(x, y, x + v.getWidth(), y + v.getHeight());

		LabelIconView siv = v.getStatusImageView();
		if (siv != null) {
			createIconImageView(siv, null, bmp1, null, x - 50, y);
		}
	}

	@Override
	protected void onStart() {
		super.onStart();
	}

	private void leftButtonOnClick() {
		moveButtonOnClick(-1);
		setStatus();
	}

	private void rightButtonOnClick() {
		moveButtonOnClick(1);
		setStatus();
	}

	private void moveButtonOnClick(int dx) {
		int mx = 0;

		if (dx < 0) {
			if (indent > 0) {
				mx = -1;
			}
		} else {
			mx = 1;
		}
		if (mx != 0) {
			indent += mx;
			removeAllNodeView();
			updateList();
		}
	}

	private void addButtonOnClick() {
		FolderUtil util = FolderUtil.getInstance();
		LabelIconView target = layout.getSelectedTarget();
		long id = target.getNodeId();
		NodeDao dao = (NodeDao) NodeDao.getInstance();
		Node parent = dao.searchById(id);
		if (parent != null) {
			DirNode node = new DirNode("XXX", null); // TODO
			util.addDirNode(parent, node);
			updateList();
			setStatus();
		}
	}

	private void deleteButtonOnClick() {
		FolderUtil util = FolderUtil.getInstance();
		LabelIconView target = layout.getSelectedTarget();
		long id = target.getNodeId();
		NodeDao dao = (NodeDao) NodeDao.getInstance();
		Node node = dao.searchById(id);
		if (node != null) {
			util.deleteNode(node);
			// TODO 三角マークも消さないといけないのでは
			layout.removeView(target);
			updateList();
			setStatus();
		}
	}

	public void execute(long srcId, long dstId) {
		removeAllNodeView();

		// TODO
		// if (dst instanceof DirNode) {
		// src.getParent().remove(src);
		// dst.add(src);
		// } else if (dst instanceof FileNode) {
		// src.getParent().remove(src);
		// dst.getParent().add(src);
		// }
		NodeDao dao = (NodeDao) NodeDao.getInstance();

		if (srcId < 0) {
			// TODO
		}
		if (dstId < 0) {
			// TODO
		}
		Node src = dao.searchById(srcId);
		Node dst = null;
		if (srcId == dstId) {
			dst = src;
		} else {
			dst = dao.searchById(dstId);
		}

		Node sp = dao.searchById(src.getParent());
		if (sp == null) {
			// TODO
		}
		Node dp = null;
		if (src.getParent() == dst.getParent()) {
			dp = sp;
		} else {
			dp = dao.searchById(dst.getParent());
		}
		if (dp == null) {
			// TODO
		}

		// TODO DBへのアクセス
		// sp.remove(src.getId());
		SQLiteDatabase db = DatabaseHelper.getInstance().getSQLiteDatabase();
		db.beginTransaction();
		try {
			dao.remoteChildrenIdNT(sp, src.getId());
			if (dst instanceof DirNode) {
				// dst.add(src.getId());
				dao.updateParentNT(src, dst.getId());
				dao.addChildrenIdNT(dst, src.getId());
			} else if (dst instanceof FileNode) {
				// dp.add(src.getId());
				dao.updateParentNT(src, dst.getId());
				dao.addChildrenIdNT(dp, src.getId());
			}

			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}		

		updateList();
	}

	public void execute(long id) {
		NodeDao dao = (NodeDao) NodeDao.getInstance();

		Node node = dao.searchById(id);
		node.toggleStatus();
		Status status = node.getStatus();

		dao.updateStatus(node, status);

		removeAllNodeView();
		updateList();
	}

	public void executeView(long id) {
		NodeDao dao = (NodeDao) NodeDao.getInstance();

		Node node = dao.searchById(id);
		String guid = node.getGuid();

		EvernoteIntentUtil util = EvernoteIntentUtil.getInstance();
		util.viewNote(this, guid);
	}

	public void targetSelectedChanged(boolean status) {
		setStatus();
	}

	public void removeAllNodeView() {
		layout.removeAllViews();
	}

	private void setStatus() {
		boolean leftButtonFlag = true;
		boolean rightButtonFlag = true;
		boolean addButtonFlag = true;
		boolean deleteButtonFlag = true;

		if (indent <= 0) {
			leftButtonFlag = false;
		}

		LabelIconView target = layout.getSelectedTarget();
		NodeDao dao = (NodeDao) NodeDao.getInstance();
		long id = -1;
		Node node = null;
		if (target != null) {
			id = target.getNodeId();
			node = dao.searchById(id);
		}
		if (target == null || node == null || !(node instanceof DirNode)) {
			addButtonFlag = false;
		}
		if (target == null || (node != null && node instanceof RootNode)) {
			deleteButtonFlag = false;
		}

		leftButton.setEnabled(leftButtonFlag);
		rightButton.setEnabled(rightButtonFlag);
		addButton.setEnabled(addButtonFlag);
		deleteButton.setEnabled(deleteButtonFlag);
	}
}