/*
 * Copyright (C) 2010, 2014 Yoshinori Sato <ysato@users.sourceforge.jp>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

	.h8300s

	.section	.vector,"ax"
	.long	__start
	.long	__start
vector	=	2
	.rept	126
	.long	__ram_vec + (vector * 4)
vector	=	vector + 1
	.endr

	.global	_start
	.global	relocate_code
	.text
	.align	2
_start:
	mov.l	#_init_stack,sp
	bsr	1f
1:
	mov.l	@sp+,er0
	mov.l	#lowlevel_init,er1
	sub.l	#1b,er1
	add.l	er1,er0
	jsr	@er0

	mov.l	#__bss_start,er4
	mov.l	#__bss_end,er5
	sub	er4,er5
	shlr.l	#2,er5
	mov	#0,er0
1:	mov.l	er0,@er4		/* bss clear */
	adds	#4,er4
	dec.l	#1,er5
	bne	1b

	mov.l	#CONFIG_SYS_LOAD_ADDR - CONFIG_SYS_GBL_DATA_SIZE - CONFIG_SYS_MALLOC_LEN,er0
	mov.l	er0,sp
	mov.l	er0,@gd
	jsr	@board_init_f
	bra	.

relocate_code:
	mov.l	er1,er0
	sub.l	er1,er1
	jmp	@board_init_r
	
	.end

