//! @file		pf_ultra.h
//! @brief		プラットフォーム(超音波)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_ULTRA_H
#define PF_ULTRA_H

#include "pf_types.h"

//! @brief		測定上限[cm]
#define PF_ULTRA_UPPER_LIMIT		((u4)200U)

//! @brief		超音波初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_ultra_init(void);

//! @brief		超音波定期タスク
//! @remarks	プラットフォーム定期タスク(入力系)処理から呼び出すこと
void pf_ultra_task(void);

//! @brief		超音波測定の有効化・無効化
//! @param		[in] enable		有効フラグ(TRUE=有効化/FALSE=無効化)
void pf_ultra_enable(BOOL enable);

//! @brief		距離取得
//! @return		前方障害物までの距離(単位:cm)
u4 pf_ultra_get(void);

#endif  // PF_ULTRA_H
