//! @file		pf_button.h
//! @brief		プラットフォーム(ボタン)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_BUTTON_H
#define PF_BUTTON_H

#include "pf_types.h"

//! @brief		ボタンのID
typedef enum PF_BUTTON_ID_Tag
{
	PF_BUTTON_ID_BUTTON_A,					//!< BUTTON A(Display面から見て左側)
	PF_BUTTON_ID_BUTTON_B,					//!< BUTTON B(Display面から見て右側)
	PF_BUTTON_ID_MAX,						//!< (IDの個数を表す)
} PF_BUTTON_ID;

//! @brief		ボタン初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_button_init(void);

//! @brief		ボタン定期タスク
//! @remarks	プラットフォーム定期タスク(入力系)処理から呼び出すこと
void pf_button_task(void);

//! @brief		ボタンの押下状態を取得
//! @details	モジュール内部でチャタリング除去処理が行われる
//! @param		[in] id			ボタンのID
//! @return		押下状態(TRUE=押されている/FALSE=押されていない)
BOOL pf_button_get(PF_BUTTON_ID id);

#endif  // PF_BUTTON_H
