/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.editors;

import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.widgets.Composite;

/**
 * TomcatFileFieldEditor
 *
 * @author Bruno
 */
public class TomcatFileFieldEditor extends FileFieldEditor {

	/** enabledField */
	private boolean enabledField = true;

	/**
	 * Constructor
	 * @param name String
	 * @param labelText String
	 * @param parent Composite
	 */
	public TomcatFileFieldEditor(final String name, final String labelText, final Composite parent) {
		super(name, labelText, parent);
	}

	/**
	 * @see org.eclipse.jface.preference.StringFieldEditor#doCheckState()
	 */
	@Override
	protected boolean doCheckState() {
		if (this.enabledField) {
			return super.doCheckState();
		}
		return true;
	}

	/**
	 * @see org.eclipse.jface.preference.StringButtonFieldEditor#setEnabled(boolean, org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void setEnabled(final boolean enabled, final Composite parent) {
		this.enabledField = enabled;
		super.setEnabled(enabled, parent);
	}

	/**
	 * @see org.eclipse.jface.preference.StringFieldEditor#valueChanged()
	 */
	@Override
	public void valueChanged() {
		super.valueChanged();
	}
}
