/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

/**
 * ProjectListElement
 *
 */
public class ProjectListElement {

	/** IProject */
	private IProject project;

	/**
	 * Constructor
	 * @param prj IProject
	 */
	public ProjectListElement(final IProject prj) {
		super();
		this.project = prj;
	}

	/**
	 * @return String
	 */
	@Override
	public String toString() {
		return getID(this.project);
	}

	/**
	 *
	 * @return ID
	 */
	public String getID() {
		return getID(this.project);
	}

	/**
	 *
	 * @param project IProject
	 * @return ID
	 */
	protected static String getID(final IProject project) {
		return project.getName();
	}

	/**
	 *
	 * @param projectIdList List<String>
	 * @return List<ProjectListElement>
	 */
	public static List<ProjectListElement> stringsToProjectsList(final List<String> projectIdList) {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

		List<ProjectListElement> selectedProjects = new ArrayList<>();
		for (final IProject project : root.getProjects()) {
			if (projectIdList.contains(getID(project))) {
				selectedProjects.add(new ProjectListElement(project));
			}
		}

		return selectedProjects;
	}

	/**
	 * @see Object#equals(Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (obj instanceof ProjectListElement) {
			return getID().equals(((ProjectListElement)obj).getID());
		}
		return false;
	}

	/**
	 * @see Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return getID().hashCode();
	}

	/**
	 * Gets the project.
	 * @return Returns a IProject
	 */
	public IProject getProject() {
		return this.project;
	}
}
