/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.actions;

import org.eclipse.core.runtime.CoreException;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProject;

/**
 * UpdateTomcatContextActionDelegate
 *
 */
public class UpdateTomcatContextActionDelegate extends TomcatProjectAbstractActionDelegate {

	/**
	 * @see com.sysdeo.eclipse.tomcat.actions.TomcatProjectAbstractActionDelegate
	 * #doActionOn(com.sysdeo.eclipse.tomcat.TomcatProject)
	 */
	@Override
	public void doActionOn(final TomcatProject prj) throws CoreException {

		if (prj.getUpdateXml()) {
			prj.updateContext();
		} else {
			throw new TomcatActionException(
					TomcatLauncherPlugin.getResourceString("msg.action.updateServerXML.failed"));
		}
	}
}
