/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_MAINPAGE_DESCRIPTION;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_MAINPAGE_TITLE;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_TITLE;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_TOMCATPAGE_DESCRIPTION;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_TOMCATPAGE_TITLE;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/**
 * TomcatProjectCreationWizard
 *
 */
public class TomcatProjectCreationWizard extends NewElementWizard implements IExecutableExtension {

	/** NewTomcatProjectWizardPage */
	private NewTomcatProjectWizardPage fTomcatPage;
	/** NewJavaProjectWizardPage */
	private JavaCapabilityConfigurationPage fJavaPage;
	/** WizardNewProjectCreationPage */
	private WizardNewProjectCreationPage fMainPage;
	/** IConfigurationElement */
	private IConfigurationElement fConfigElement;

	/**
	 * Constructor
	 */
	public TomcatProjectCreationWizard() {
		super();
		TomcatLauncherPlugin.checkTomcatSettingsAndWarn();
		ImageDescriptor banner = getBannerImg();
		if (banner != null) {
			setDefaultPageImageDescriptor(banner);
		}
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(WIZARD_PROJECT_TITLE);
	}

	/**
	 *
	 * @return boolean
	 */
	@Override
	public boolean canFinish() {
		return TomcatLauncherPlugin.isTomcatConfigured();

	}

	/**
	 *
	 * @return ImageDescriptor
	 */
	private ImageDescriptor getBannerImg() {
		try {
			URL prefix = new URL(TomcatLauncherPlugin.getDefault().getBundle().getEntry("/"), "icons/");
			return ImageDescriptor.createFromURL(new URL(prefix, "newjprj_wiz.gif"));
		} catch (final MalformedURLException e) {
			TomcatLauncherPlugin.log(e);
			return null;
		}
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	@Override
	public void addPages() {
		super.addPages();
		this.fMainPage = new WizardNewProjectCreationPage("Page 1");
		this.fMainPage.setTitle(WIZARD_PROJECT_MAINPAGE_TITLE);
		this.fMainPage.setDescription(WIZARD_PROJECT_MAINPAGE_DESCRIPTION);
		addPage(this.fMainPage);

		this.fTomcatPage = new NewTomcatProjectWizardPage("NewTomcatProjectPage");
		this.fTomcatPage.setTitle(WIZARD_PROJECT_TOMCATPAGE_TITLE);
		this.fTomcatPage.setDescription(WIZARD_PROJECT_TOMCATPAGE_DESCRIPTION);
		addPage(this.fTomcatPage);

		this.fJavaPage = new JavaCapabilityConfigurationPage();
		this.fJavaPage.init(JavaCore.create(this.fMainPage.getProjectHandle()),
						this.fMainPage.getLocationPath(), null, false);

	}

	/**
	 * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this.fJavaPage.getRunnable());
		try {
			getContainer().run(false, true, op);
			TomcatProject.addTomcatNature(this.fJavaPage.getJavaProject());
			TomcatProject tomcatPrj = TomcatProject.create(this.fJavaPage.getJavaProject());
			tomcatPrj.setWebPath(this.fTomcatPage.getWebPath());
			tomcatPrj.setUpdateXml(this.fTomcatPage.getUpdateXml());
			tomcatPrj.setRootDir(this.fTomcatPage.getRootDir());
			tomcatPrj.saveProperties();
			tomcatPrj.fullConfiguration();

			BasicNewProjectResourceWizard.updatePerspective(this.fConfigElement);
			selectAndReveal(this.fJavaPage.getJavaProject().getProject());
			return true;
		} catch (final InvocationTargetException e) {
			String title = NewWizardMessages.JavaProjectWizard_op_error_title;
			String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
			ExceptionHandler.handle(e, getShell(), title, message);
		} catch (final InterruptedException e) {
			TomcatLauncherPlugin.log(e);
		} catch (final CoreException e) {
			TomcatLauncherPlugin.log(e);
		}
		return false;
	}

	/**
	 * Stores the configuration element for the wizard.  The config element will be used
	 * in <code>performFinish</code> to set the result perspective.
	 */
	@Override
	public void setInitializationData(final IConfigurationElement cfig, final String propertyName, final Object data) {
		this.fConfigElement = cfig;
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#getNextPage(org.eclipse.jface.wizard.IWizardPage)
	 */
	@Override
	public IWizardPage getNextPage(final IWizardPage page) {
		// initialize Tomcat Wizard page webpath field
		// Default value is / + projectName
		if (page instanceof WizardNewProjectCreationPage) {
			if (!this.fTomcatPage.wasDisplayedOnce()) {
				this.fTomcatPage.setWebPath("/" + this.fMainPage.getProjectName());
			}
		}

		return super.getNextPage(page);
	}

	/**
	 * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#finishPage(org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	protected void finishPage(final IProgressMonitor monitor) throws InterruptedException, CoreException {
		// for Eclipse 3.0 compatibility
	}

	/**
	 * Getters for subclasses
	 * @return IConfigurationElement
	 */
	protected IConfigurationElement getFConfigElement() {
		return this.fConfigElement;
	}

	/**
	 *
	 * @return NewJavaProjectWizardPage
	 */
	protected JavaCapabilityConfigurationPage getFJavaPage() {
		return this.fJavaPage;
	}

	/**
	 *
	 * @return WizardNewProjectCreationPage
	 */
	protected WizardNewProjectCreationPage getFMainPage() {
		return this.fMainPage;
	}

	/**
	 *
	 * @return NewTomcatProjectWizardPage
	 */
	protected NewTomcatProjectWizardPage getFTomcatPage() {
		return this.fTomcatPage;
	}

	/**
	 * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#getCreatedElement()
	 */
	@Override
	public IJavaElement getCreatedElement() {
		return null;
	}
}
