/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.NATURE_ID;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PLUGIN_ID;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_BASE_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_PROJECTINCP_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_SECURITYMANAGER_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.TOMCAT_PREF_BASE_KEY;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.TOMCAT_PREF_SECURITYMANAGER;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

import com.sysdeo.eclipse.tomcat.editors.ProjectListEditor;

/**
 * AdvancedPreferencePage
 *
 */
public class AdvancedPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {

	/** BooleanFieldEditor */
	private BooleanFieldEditor securityEditor;
	/** DirectoryFieldEditor */
	private DirectoryFieldEditor base;
	/** ProjectListEditor */
	private ProjectListEditor projectListEditor;

	/**
	 * Constructor
	 */
	public AdvancedPreferencePage() {
		super();
		setPreferenceStore(TomcatLauncherPlugin.getDefault().getPreferenceStore());
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	@Override
	protected Control createContents(final Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));

		Group homeGroup = new Group(composite, SWT.NONE);
		this.base = new DirectoryFieldEditor(TOMCAT_PREF_BASE_KEY,
				PREF_PAGE_BASE_LABEL, homeGroup);
		initLayoutAndData(homeGroup, 3);

		Group securityGroup = new Group(composite, SWT.NONE);
		this.securityEditor = new BooleanFieldEditor(TOMCAT_PREF_SECURITYMANAGER,
			PREF_PAGE_SECURITYMANAGER_LABEL, securityGroup);
		initField(this.securityEditor);
		initLayoutAndData(securityGroup, 1);

		Group projectListGroup = new Group(composite, SWT.NONE);
		String[] excludedProjectsNature = {NATURE_ID};
		this.projectListEditor = new ProjectListEditor(excludedProjectsNature);
		this.projectListEditor.setLabel(PREF_PAGE_PROJECTINCP_LABEL);
		Control projectList = this.projectListEditor.getControl(projectListGroup);
		GridData gd2 = new GridData();
		gd2.horizontalAlignment = GridData.FILL;
		projectList.setLayoutData(gd2);
		initLayoutAndData(projectListGroup, 1);

		initField(this.base);

		//blank
		Label lbl = new Label(composite, SWT.NULL);
		lbl.setParent(composite);

		return composite;
	}

	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	@Override
	public void init(final IWorkbench workbench) {
		return;
	}

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	@Override
	public boolean performOk() {
		this.base.store();
		this.securityEditor.store();
		TomcatLauncherPlugin.setProjectsInCP(this.projectListEditor.getCheckedElements());
		try {
			InstanceScope.INSTANCE.getNode(PLUGIN_ID).flush();
		} catch (final BackingStoreException e) {
			TomcatLauncherPlugin.log(e);
			return false;
		}
		return true;
	}

	/**
	 * initField
	 * @param field FieldEditor
	 */
	private void initField(final FieldEditor field) {
		field.setPreferenceStore(getPreferenceStore());
		field.setPage(this);
		field.load();
	}

	/**
	 * initLayoutAndData
	 * @param aGroup Group
	 * @param numColumns Columns
	 */
	private void initLayoutAndData(final Group aGroup, final int numColumns) {
		GridLayout gl = new GridLayout(numColumns, false);
		aGroup.setLayout(gl);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 1;
		gd.widthHint = 400;
		aGroup.setLayoutData(gd);
	}
}
