package project.common;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

import project.common.CsvUtil;

public class TestCsvUtil {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestCsvUtil.class.getName());
	}

	@Test
	public void CSV文字列カンマ含む改行CRLF終了配列化() {
		String[] vals = CsvUtil.toArray(",aaa,\"bbbb,\"\r\n");
		Assert.assertEquals(3, vals.length);
		Assert.assertEquals("", vals[0]);
		Assert.assertEquals("aaa", vals[1]);
		Assert.assertEquals("bbbb,", vals[2]);
	}

	@Test
	public void 文字列配列改行CRありCSV文字列化() {
		String val = CsvUtil.toCsv("aaaa", ",", "aaa\r\nbbb", "\"ddd");
		Assert.assertEquals("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"", val);
	}

	@Test
	public void 文字列配列改行LFありCSV文字列化() {
		String val = CsvUtil.toCsv("aaaa", ",", "aaa\nbbb", "\"ddd");
		Assert.assertEquals("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"", val);
	}

	public void CSV文字列配列化改行CRダブルクォートあり() {
		String[] vals = CsvUtil.toArray("aaaa,\",\",\"aaa\r\nbbb\",\"\"\"ddd\"\r\n");
		Assert.assertEquals(4, vals.length);
		Assert.assertEquals("aaaa", vals[0]);
		Assert.assertEquals(",", vals[1]);
		Assert.assertEquals("aaa\r\nbbb", vals[2]);
		Assert.assertEquals("\"ddd", vals[3]);
	}

	@Test
	public void CSV文字列配列化改行LFダブルクォートあり() {
		String[] vals = CsvUtil.toArray("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"\r\n");
		Assert.assertEquals(4, vals.length);
		Assert.assertEquals("aaaa", vals[0]);
		Assert.assertEquals(",", vals[1]);
		Assert.assertEquals("aaa\nbbb", vals[2]);
		Assert.assertEquals("\"ddd", vals[3]);
	}

	@Test
	public void CSV文字列配列化カンマ終了() {
		String[] vals = CsvUtil.toArray("1,");
		Assert.assertEquals(2, vals.length);
		Assert.assertEquals("1", vals[0]);
		Assert.assertEquals("", vals[1]);
	}
}
