package online.model;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestUniModelNumber {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestUniModelNumber.class.getName());
	}

	@Test
	public void testNoValue1() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertNull(um.getNumber("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.addValue("AAAAA", Integer.valueOf(1));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(Integer.valueOf(1), um.getNumber("AAAAA"));
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}

	@Test
	public void testNoValue2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", BigDecimal.TEN);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(BigDecimal.TEN, um.getNumber("AAAAA"));
		Assert.assertEquals(BigDecimal.TEN, um.getNumberArray("AAAAA")[0]);
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.noValue("AAAAA");
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertNull(um.getNumber("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.addValue("AAAAA", BigDecimal.ONE);
		um.addValue("AAAAA", BigDecimal.ZERO);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(2, um.getArraySize("AAAAA"));
		Assert.assertEquals(2, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(BigDecimal.ONE, um.getNumberArray("AAAAA")[0]);
		Assert.assertEquals(BigDecimal.ZERO, um.getNumberArray("AAAAA")[1]);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}


	@Test
	public void testAliasKey0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BBBBB")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertNull(um.getNumber("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}

	@Test
	public void testAliasKey1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Integer)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Integer[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Long)null);
		um.addValue("bbbbb", (Long)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new Boolean[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (BigInteger)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (BigInteger)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getNumberArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getNumberArray("bbbbb").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}

	@Test
	public void testAliasKey6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Short[])null);
		um.addValue("bbbbb", (Short)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Float[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Float[]{Float.valueOf(1.0F), Float.valueOf(2.05F)});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(Float.valueOf(1.0F), um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(Float.valueOf(2.05F), um.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getNumberArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getNumberArray("bbbbb").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}

	@Test
	public void testAliasKey8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Double[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Double)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getNumberArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getNumberArray("bbbbb").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}


	@Test
	public void testArraySize1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Short)null);
		um.addValue("aaaaa", (Short)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new BigInteger[]{null});

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (BigDecimal)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (BigDecimal)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigInteger[])null);
		um.addValue("aaaaa", (BigInteger)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Integer[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Integer[]{Integer.valueOf(100), Integer.valueOf(200)});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(Integer.valueOf(100), um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(Integer.valueOf(200), um.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Long)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}


	@Test
	public void testcopyValue0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Float[])null);
		um.setValue("bbbbb", new Float[0]);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Double)null);
		um.addValue("aaaaa", (Double)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new BigInteger[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (BigDecimal)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (BigDecimal)null);
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer[])null);
		um.addValue("aaaaa", (Integer)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Long[]{Long.valueOf(12354566777L), Long.valueOf(-23456L)});
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getNumberArray("aaaaa")[2], um1.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Short[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Short)null);
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void testputValue0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigDecimal)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigInteger[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);
		um.addValue("aaaaa", (Byte)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Double[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Float)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Float)null);
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer[])null);
		um.addValue("aaaaa", (Integer)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Short[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Short[]{Short.valueOf((short)123), Short.valueOf((short)223)});
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getNumberArray("aaaaa")[2], um1.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Long)null);
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void testputAll0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigDecimal)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigInteger[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);
		um.addValue("aaaaa", (Byte)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Float[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Double)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Double)null);
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer[])null);
		um.addValue("aaaaa", (Integer)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Byte[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Byte[]{Byte.valueOf((byte)0x10), Byte.valueOf((byte)0x20)});
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getNumberArray("aaaaa")[2], um1.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Short[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Short)null);
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void testaddAll0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testaddAll1() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (BigDecimal)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getNumberArray("aaaaa")[0]);
		Assert.assertNull(um1.getNumber("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testaddAll2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getNumberArray("aaaaa")[0]);
		Assert.assertNull(um1.getNumber("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testaddAll3() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (Long)null);
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(2, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(null, um1.getNumberArray("aaaaa")[1]);
		Assert.assertNull(um1.getNumber("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}
}
