package online.model;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestUniModelDate {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestUniModelDate.class.getName());
	}

	@Test
	public void noValueTest1() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertNull(um.getDate("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getDateArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		Date now = new Date();
		um.addValue("AAAAA", now);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(now, um.getDate("AAAAA"));
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getDateArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}

	@Test
	public void noValueTest2() {
		Date now = new Date();
		UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", now);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(now, um.getDate("AAAAA"));
		Assert.assertEquals(now, um.getDateArray("AAAAA")[0]);
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getDateArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.noValue("AAAAA");
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertNull(um.getDate("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getDateArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		Date now1 = new Date();
		um.addValue("AAAAA", now1);
		Date now2 = new Date();
		um.addValue("AAAAA", now2);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(2, um.getArraySize("AAAAA"));
		Assert.assertEquals(2, um.getDateArray("AAAAA").length);
		Assert.assertEquals(now1, um.getDateArray("AAAAA")[0]);
		Assert.assertEquals(now2, um.getDateArray("AAAAA")[1]);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}


	@Test
	public void aliasKeyTest0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BBBBB")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertNull(um.getDate("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getDateArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}

	@Test
	public void aliasKeyTest1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void aliasKeyTest2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void aliasKeyTest3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date)null);
		um.addValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void aliasKeyTest4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new Date[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void aliasKeyTest5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertEquals(null, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getDateArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getDateArray("bbbbb").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}

	@Test
	public void aliasKeyTest6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Date[])null);
		um.addValue("bbbbb", (Date)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void aliasKeyTest7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Date[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Date now1 = new Date();
		Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(now1, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(now2, um.getDateArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getDateArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getDateArray("bbbbb").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}

	@Test
	public void aliasKeyTest8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Date[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getDateArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getDateArray("bbbbb").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}


	@Test
	public void arraySizeTest1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Date now1 = new Date();
		Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(now1, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(now2, um.getDateArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void arraySizeTest8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getDateArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getDateArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}


	@Test
	public void copyValueTest0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.setValue("bbbbb", new Date[0]);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		Date now1 = new Date();
		Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getDateArray("aaaaa")[2], um1.getDateArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void copyValueTest8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void putValueTest0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		Date now1 = new Date();
		Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getDateArray("aaaaa")[2], um1.getDateArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putValueTest8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void putAllTest0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Date[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date[])null);
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		Date now1 = new Date();
		Date now2 = new Date();
		um.addValue("aaaaa", new Date[]{now1, now2});
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getDateArray("aaaaa")[2], um1.getDateArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void putAllTest8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Date)null);
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getDateArray("aaaaa")[1], um1.getDateArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void addAllTest0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getDateArray("aaaaa").length, um1.getDateArray("aaaaa").length);
		Assert.assertNull(um.getDate("aaaaa"));
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void addAllTest1() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getDateArray("aaaaa")[0]);
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void addAllTest2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getDateArray("aaaaa")[0]);
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void addAllTest3() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Date)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (Date)null);
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(2, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getDateArray("aaaaa")[0]);
		Assert.assertEquals(null, um1.getDateArray("aaaaa")[1]);
		Assert.assertNull(um1.getDate("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}
}
