package online.model;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestUniModelBoolean {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestUniModelBoolean.class.getName());
	}

	@Test
	public void testNoValue1() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(null, um.getBoolean("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getBooleanArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.addValue("AAAAA", Boolean.FALSE);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("AAAAA"));
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getBooleanArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}

	@Test
	public void testNoValue2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", Boolean.TRUE);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("AAAAA"));
		Assert.assertEquals(Boolean.TRUE, um.getBooleanArray("AAAAA")[0]);
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getBooleanArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.noValue("AAAAA");
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(null, um.getBoolean("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getBooleanArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));

		um.addValue("AAAAA", Boolean.FALSE);
		um.addValue("AAAAA", Boolean.TRUE);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(2, um.getArraySize("AAAAA"));
		Assert.assertEquals(2, um.getBooleanArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, um.getBooleanArray("AAAAA")[0]);
		Assert.assertEquals(Boolean.TRUE, um.getBooleanArray("AAAAA")[1]);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}


	@Test
	public void testAliasKey0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("BBBBB")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("AAAAA")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("AAAAA")));
		Assert.assertEquals(null, um.getBoolean("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getBooleanArray("AAAAA").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("AAAAA")));
	}

	@Test
	public void testAliasKey1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean)null);
		um.addValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new Boolean[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getBooleanArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getBooleanArray("bbbbb").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}

	@Test
	public void testAliasKey6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean[])null);
		um.addValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testAliasKey7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Boolean[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, um.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(Boolean.TRUE, um.getBooleanArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getBooleanArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getBooleanArray("bbbbb").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}

	@Test
	public void testAliasKey8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Boolean[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("bbbbb")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("bbbbb")));
		Assert.assertEquals(null, um.getBooleanArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getBooleanArray("bbbbb").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("bbbbb")));
	}


	@Test
	public void testArraySize1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBoolean("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, um.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(Boolean.FALSE, um.getBooleanArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}

	@Test
	public void testArraySize8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("aaaaa")));
		Assert.assertEquals(null, um.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("aaaaa")));
	}


	@Test
	public void testcopyValue0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.setValue("bbbbb", new Boolean[0]);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getBooleanArray("aaaaa")[2], um1.getBooleanArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testcopyValue8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		um.copyValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void testputValue0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getBooleanArray("aaaaa")[2], um1.getBooleanArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputValue8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		um.putValueTo(um1, "aaaaa");

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void testputAll0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll1() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll3() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll4() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll5() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll6() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll7() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getBooleanArray("aaaaa")[2], um1.getBooleanArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testputAll8() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));

		um.addValue("aaaaa", (Boolean)null);
		um1.putAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}


	@Test
	public void testaddAll0() {
		UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.valueOf(um.containsKey("aaaaa")), Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.valueOf(um.hasValue("aaaaa")), Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assert.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assert.assertEquals(Boolean.valueOf(um.isArrayValue("aaaaa")), Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testaddAll1() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(null, um1.getBoolean("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testaddAll2() {
		UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(null, um1.getBoolean("aaaaa"));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}

	@Test
	public void testaddAll3() {
		UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (Boolean)null);
		um1.addAll(um);

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.containsKey("aaaaa")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.hasValue("aaaaa")));
		Assert.assertEquals(2, um1.getArraySize("aaaaa"));
		Assert.assertEquals(null, um1.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(null, um1.getBooleanArray("aaaaa")[1]);
		Assert.assertEquals(null, um1.getBoolean("aaaaa"));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um1.isArrayValue("aaaaa")));
	}
}
