package online.model;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestModelUtilDate {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestModelUtilDate.class.getName());
	}

	@Test
	public void setBeanItemValueTest1() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Date");
		ModelUtil.setBeanItemValue(um, bean, "DateArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Date")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("Date")));
		Assert.assertNull(um.getDate("Date"));
		Assert.assertEquals(0, um.getArraySize("Date"));
		Assert.assertEquals(0, um.getDateArray("Date").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Date")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("DateArray")));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.hasValue("DateArray")));
		Assert.assertNull(um.getDate("DateArray"));
		Assert.assertEquals(0, um.getArraySize("DateArray"));
		Assert.assertEquals(0, um.getDateArray("DateArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("DateArray")));
	}

	@Test
	public void setBeanItemValueTest2() {
		Date now = new Date();
		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Date");
		ModelUtil.setBeanItemValue(um, bean, "DateArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Date")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Date")));
		Assert.assertEquals(now, um.getDate("Date"));
		Assert.assertEquals(1, um.getArraySize("Date"));
		Assert.assertEquals(1, um.getDateArray("Date").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Date")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("DateArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("DateArray")));
		Assert.assertEquals(now, um.getDate("DateArray"));
		Assert.assertEquals(1, um.getArraySize("DateArray"));
		Assert.assertEquals(1, um.getDateArray("DateArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("DateArray")));
	}


	@Test
	public void addBeanItemValueTest1() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Date");
		ModelUtil.addBeanItemValue(um, bean, "DateArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Date")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Date")));
		Assert.assertNull(um.getDate("Date"));
		Assert.assertEquals(1, um.getArraySize("Date"));
		Assert.assertEquals(1, um.getDateArray("Date").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Date")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("DateArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("DateArray")));
		Assert.assertEquals(null, um.getDateArray("DateArray")[0]);
		Assert.assertEquals(1, um.getArraySize("DateArray"));
		Assert.assertEquals(1, um.getDateArray("DateArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("DateArray")));
	}

	@Test
	public void addBeanItemValueTest2() {
		Date now = new Date();
		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Date");
		ModelUtil.addBeanItemValue(um, bean, "DateArray");

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("Date")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("Date")));
		Assert.assertEquals(now, um.getDate("Date"));
		Assert.assertEquals(1, um.getArraySize("Date"));
		Assert.assertEquals(1, um.getDateArray("Date").length);
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(um.isArrayValue("Date")));

		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.containsKey("DateArray")));
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.hasValue("DateArray")));
		Assert.assertEquals(now, um.getDateArray("DateArray")[0]);
		Assert.assertEquals(1, um.getArraySize("DateArray"));
		Assert.assertEquals(1, um.getDateArray("DateArray").length);
		Assert.assertEquals(Boolean.TRUE, Boolean.valueOf(um.isArrayValue("DateArray")));
	}


	@Test
	public void setModelValueTest1() {
		UniModelImpl um = new UniModelImpl();

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());
	}

	@Test
	public void setModelValueTest2() {
		Date now = new Date();

		UniModelImpl um = new UniModelImpl();
		um.setValue("Date", now);
		um.setValue("DateArray", new Date[]{now});

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(now, bean.getDate());
		Assert.assertEquals(now, bean.getDateArray()[0]);
	}

	@Test
	public void setModelValueTest3() {
		Date now1 = new Date();
		Date now2 = new Date();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBooleanArray", new Date[]{now1, now2});
		um.setValue("BooleanArray", new Date[]{now1, now2});

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBooleanArray()[0]));
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBooleanArray()[1]));
		Assert.assertNull(bean.isBooleanArray()[0]);
		Assert.assertNull(bean.isBooleanArray()[1]);
	}

	@Test
	public void setModelValueTest4() {
		Date now1 = new Date();
		Date now2 = new Date();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveIntegerArray", new Date[]{now1, now2});
		um.setValue("IntegerArray", new Date[]{now1, now2});

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(0, bean.getPrimitiveIntegerArray()[0]);
		Assert.assertEquals(0, bean.getPrimitiveIntegerArray()[1]);
		Assert.assertNull(bean.getIntegerArray()[0]);
		Assert.assertNull(bean.getIntegerArray()[1]);
	}

	@Test
	public void setModelValueTest5() {
		Date now = new Date();

		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", (Date[])null);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}

	@Test
	public void setModelValueTest6() {
		Date now = new Date();

		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", new Date[0]);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}


	@Test
	public void setModelValueTest10() {
		JavaBean bean = new JavaBean();
		UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());
	}

	@Test
	public void setModelValueTest11() {
		Date now = new Date();

		UniModelImpl um = new UniModelImpl();
		um.setValue("Date", new Date[]{null, now});

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals(now, bean.getDate());
	}

	@Test
	public void setModelValueTest12() {
		Date now1 = new Date();
		Date now2 = new Date();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", new Date[]{now1, now2});
		um.setValue("Boolean", new Date[]{now1, now2});

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBooleanArray());
		Assert.assertEquals(Boolean.FALSE, Boolean.valueOf(bean.isPrimitiveBoolean()));
		Assert.assertNull(bean.isBoolean());
	}

	@Test
	public void setModelValueTest13() {
		Date now1 = new Date();
		Date now2 = new Date();

		UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new Date[]{now1, now2});
		um.setValue("Integer", new Date[]{now1, now2});

		JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
		Assert.assertEquals(0, bean.getPrimitiveInteger());
		Assert.assertNull(bean.getInteger());
	}

	@Test
	public void setModelValueTest15() {
		Date now = new Date();

		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", (Date[])null);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}

	@Test
	public void setModelValueTest16() {
		Date now = new Date();

		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", new Date[0]);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNotNull(bean.getDateArray());
		Assert.assertEquals(0, bean.getDateArray().length);
	}


	@Test
	public void setModelValueTest20() {
		Date now = new Date();

		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		UniModelImpl um = new UniModelImpl();
		um.noValue("Date");
		um.noValue("DateArray");
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());
	}

	@Test
	public void setModelValueTest21() {
		Date now = new Date();

		JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		UniModelImpl um = new UniModelImpl();
		um.noValue("Date");
		um.noValue("DateArray");

		ModelUtil.setModelValue(bean, um, 0);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getDateArray());

		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getDate());
		Assert.assertNull(bean.getStringArray());
	}


	@Test
	public void setModelValueTest31() {
		Date now1 = new Date();
		Date now2 = new Date();

		JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Date[]{now1, now2});
		um.setValue("StringArray", new Date[]{now2, now2});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals(now1.toString(), bean.getStringArray()[0]);
		Assert.assertEquals(now2.toString(), bean.getStringArray()[1]);
	}
}
