package core.util;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class TestArrayUtil {

	/**
	 * main
	 * @param args arguments
	 */
	public static void main(final String... args) {
		JUnitCore.main(TestArrayUtil.class.getName());
	}

	@Test
	public void コピーテスト() {
		String[] val = new String[]{"1", "2", "3"};
		Assert.assertArrayEquals(val, ArrayUtil.copyOf(val));
	}

	@Test
	public void コピーテストnull時() {
		Assert.assertNull(ArrayUtil.copyOf(null));
	}

	@Test
	public void コピーテスト空時() {
		String[] val = {};
		Assert.assertArrayEquals(val, ArrayUtil.copyOf(val));
	}

	@Test
	public void コピーテストデフォルト() {
		String[] val = {"2"};
		Assert.assertArrayEquals(val, ArrayUtil.copyOf(null, val));
	}


	@Test
	public void 全設定テスト() {
		String[] val = new String[5];
		Assert.assertArrayEquals(new String[]{"1", "1", "1", "1", "1"}, ArrayUtil.fill("1" , val));
	}

	@Test
	public void 全設定テストnull() {
		String[] val = new String[5];
		Assert.assertArrayEquals(new String[5], ArrayUtil.fill(null , val));
	}

	@Test
	public void 全設定テスト空時() {
		String[] val = {};
		Assert.assertArrayEquals(new String[0], ArrayUtil.fill(null , val));
	}


	@Test
	public void ソートテスト() {
		String[] val = new String[]{"1", "5", "3", "4", "2"};
		Assert.assertArrayEquals(new String[]{"1", "2", "3", "4", "5"}, ArrayUtil.sort(val));
	}

	@Test
	public void ソートテストnull() {
		Assert.assertNull(ArrayUtil.sort(null));
	}

	@Test
	public void ソートテスト空() {
		Assert.assertArrayEquals(new String[0], ArrayUtil.sort(new String[]{}));
	}


	@Test
	public void 検索テスト() {
		String[] val = new String[]{"1", "5", "3", "4", "2"};
		Assert.assertEquals(3, ArrayUtil.find(val, "4"));
	}

	@Test
	public void 検索テストnull() {
		Assert.assertEquals(-1, ArrayUtil.find(null, null));
	}

	@Test
	public void 検索テスト空() {
		Assert.assertEquals(-1, ArrayUtil.find(new String[0], "1"));
	}

	@Test
	public void 検索テスト途中以降() {
		String[] val = new String[]{"1", "5", "3", "4", "2"};
		Assert.assertEquals(3, ArrayUtil.find(val, "4", 2));
	}

	@Test
	public void 検索テスト途中以前() {
		String[] val = new String[]{"1", "5", "3", "4", "2"};
		Assert.assertEquals(-1, ArrayUtil.find(val, "5", 2));
	}


	@Test
	public void ユニークテスト() {
		Assert.assertTrue(ArrayUtil.isUnique("1", "2", "3"));
	}

	@Test
	public void ユニークテスト重複時() {
		Assert.assertFalse(ArrayUtil.isUnique("1", "2", "3", "5", "6", "3"));
	}
}
