package project.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.logging.log4j.LogManager;

import online.struts.action.PerformAction;
import online.struts.action.UniForm;
import online.struts.mapping.RequestMapping;
import project.svc.auth.Authentication;
import core.config.Factory;

/**
 * ログオフアクションクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LogoffAction extends PerformAction {
	/**
	 * ログオフ主処理
	 *
	 * @param mapping ActionMappingオブジェクト
	 * @param uf 汎用フォーム
	 * @param request HttpServletRequestオブジェクト
	 * @param response HttpServletResponseオブジェクト
	 * @return 処理結果
	 */
	@Override
	public String perform(final RequestMapping mapping, final UniForm uf,
					final HttpServletRequest request, final HttpServletResponse response) {
		HttpSession session = request.getSession(false);
		if (session != null && uf.getSessionUser() != null) {
			try {
				// ログオフ処理
				Authentication auth = Factory.create(Authentication.class);
				auth.logoff(uf.getSessionUser().getUid(), session.getId(), uf.getPresent());
			} finally {
				uf.setSessionUser(null);
				try {
					session.invalidate();
				} catch (final IllegalStateException ex) {
					LogManager.getLogger().warn(ex.getMessage());
					return ID_VIEW;
				}
			}
		}
		return ID_VIEW;
	}
}
