package project.check.existence;

import java.util.Optional;

import core.util.ArrayUtil;
import core.util.bean.Pair;
import project.check.BaseCheck;
import project.master.MsgUtil;

/**
 * 項目長等価チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class EquivalentCheck extends BaseCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public EquivalentCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public EquivalentCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = ArrayUtil.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		int length = -1;
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			if (length == -1) {
				length = 0;
				if (val != null) {
					length = val.length;
				}
			} else if (val == null || length != val.length) {
				if (!MsgUtil.hasItemMessage(super.getUniModel(), item)) {
					super.addTopMessage(this.mid, this.prm);
					MsgUtil.putMessage(super.getUniModel(), item, this.mid, this.prm);
				}
				check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(0))));
			}
		}

		check.ifPresent(this::throwNoMoreCheckException);
	}
}
