package project.check.attribute;

import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;

import core.util.ArrayUtil;
import core.util.DateUtil;
import core.util.bean.Pair;
import online.context.check.ItemConvert;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.common.CheckUtil;

/**
 * 日付妥当性チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class DateCheck extends BaseCheck implements ItemConvert<Date> {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public DateCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public DateCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = ArrayUtil.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
					continue;
				}
				String date = DateUtil.normalizeDate(val[j]);
				if (!CheckUtil.isDate(date)) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				} else {
					val[j] = date;
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}

	/**
	 * @see online.context.check.ItemConvert#convert(java.lang.String...)
	 */
	@Override
	public Date[] convert(final String... val) {
		return Stream.of(val).map(DateUtil::toDate).toArray(Date[]::new);
	}
}
